/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.os.transformers.search;

import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.os.transformers.OpensearchTransformer;
import io.camunda.search.os.transformers.OpensearchTransformers;
import io.camunda.search.os.transformers.search.SearchQueryHitTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.opensearch.core.search.TotalHits;

public final class SearchResponseTransformer<T>
extends OpensearchTransformer<SearchResponse<T>, SearchQueryResponse<T>> {
    public SearchResponseTransformer(OpensearchTransformers transformers) {
        super(transformers);
    }

    public SearchQueryResponse<T> apply(SearchResponse<T> value) {
        HitsMetadata hits = value.hits();
        String scrollId = value.scrollId();
        TotalHits total = hits.total();
        long totalHits = this.of(total);
        List sourceHits = hits.hits();
        List<SearchQueryHit<T>> transformedHits = this.of(sourceHits);
        return new SearchQueryResponse.Builder().totalHits(totalHits).scrollId(scrollId).hits(transformedHits).build();
    }

    private List<SearchQueryHit<T>> of(List<Hit<T>> hits) {
        if (hits != null) {
            SearchQueryHitTransformer hitTransformer = new SearchQueryHitTransformer(this.transformers);
            return hits.stream().map(hitTransformer::apply).collect(Collectors.toList());
        }
        return new ArrayList<SearchQueryHit<T>>();
    }

    private long of(TotalHits totalHits) {
        if (totalHits != null) {
            return totalHits.value();
        }
        return 0L;
    }
}

