/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.os.transformers.query;

import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.os.transformers.OpensearchTransformers;
import io.camunda.search.os.transformers.query.QueryOptionTransformer;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;

public final class RangeQueryTransformer
extends QueryOptionTransformer<SearchRangeQuery, RangeQuery> {
    public RangeQueryTransformer(OpensearchTransformers transformers) {
        super(transformers);
    }

    public RangeQuery apply(SearchRangeQuery value) {
        String field = value.field();
        RangeQuery.Builder builder = QueryBuilders.range().field(field);
        if (value.gt() != null) {
            builder.gt(this.of(value.gt()));
        }
        if (value.gte() != null) {
            builder.gte(this.of(value.gte()));
        }
        if (value.lt() != null) {
            builder.lt(this.of(value.lt()));
        }
        if (value.lte() != null) {
            builder.lte(this.of(value.lte()));
        }
        if (value.from() != null) {
            builder.from(JsonData.of((Object)value.from()));
        }
        if (value.to() != null) {
            builder.to(JsonData.of((Object)value.to()));
        }
        if (value.format() != null) {
            builder.format(value.format());
        }
        return builder.build();
    }

    private <T> JsonData of(T value) {
        return JsonData.of(value);
    }
}

