/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"partitionId", "role", "health"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Partition {
    public static final String JSON_PROPERTY_PARTITION_ID = "partitionId";
    @Nullable
    private Integer partitionId;
    public static final String JSON_PROPERTY_ROLE = "role";
    @Nullable
    private RoleEnum role;
    public static final String JSON_PROPERTY_HEALTH = "health";
    @Nullable
    private HealthEnum health;

    public Partition partitionId(@Nullable Integer partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="partitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty(value="partitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartitionId(@Nullable Integer partitionId) {
        this.partitionId = partitionId;
    }

    public Partition role(@Nullable RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoleEnum getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(@Nullable RoleEnum role) {
        this.role = role;
    }

    public Partition health(@Nullable HealthEnum health) {
        this.health = health;
        return this;
    }

    @Nullable
    @JsonProperty(value="health")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HealthEnum getHealth() {
        return this.health;
    }

    @JsonProperty(value="health")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHealth(@Nullable HealthEnum health) {
        this.health = health;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Objects.equals(this.partitionId, partition.partitionId) && Objects.equals((Object)this.role, (Object)partition.role) && Objects.equals((Object)this.health, (Object)partition.health);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionId, this.role, this.health});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Partition {\n");
        sb.append("    partitionId: ").append(this.toIndentedString(this.partitionId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    health: ").append(this.toIndentedString((Object)this.health)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPartitionId() != null) {
            try {
                joiner.add(String.format("%spartitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPartitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRole() != null) {
            try {
                joiner.add(String.format("%srole%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getRole()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getHealth() != null) {
            try {
                joiner.add(String.format("%shealth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getHealth()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum RoleEnum {
        LEADER(String.valueOf("leader")),
        FOLLOWER(String.valueOf("follower")),
        INACTIVE(String.valueOf("inactive")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum HealthEnum {
        HEALTHY(String.valueOf("healthy")),
        UNHEALTHY(String.valueOf("unhealthy")),
        DEAD(String.valueOf("dead")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private HealthEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HealthEnum fromValue(String value) {
            for (HealthEnum b : HealthEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

