/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.SortOrderEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"field", "order"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DecisionDefinitionSearchQuerySortRequest {
    public static final String JSON_PROPERTY_FIELD = "field";
    @Nonnull
    private FieldEnum field;
    public static final String JSON_PROPERTY_ORDER = "order";
    @Nullable
    private SortOrderEnum order = SortOrderEnum.ASC;

    public DecisionDefinitionSearchQuerySortRequest field(@Nonnull FieldEnum field) {
        this.field = field;
        return this;
    }

    @Nonnull
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FieldEnum getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setField(@Nonnull FieldEnum field) {
        this.field = field;
    }

    public DecisionDefinitionSearchQuerySortRequest order(@Nullable SortOrderEnum order) {
        this.order = order;
        return this;
    }

    @Nullable
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SortOrderEnum getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(@Nullable SortOrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionDefinitionSearchQuerySortRequest decisionDefinitionSearchQuerySortRequest = (DecisionDefinitionSearchQuerySortRequest)o;
        return Objects.equals((Object)this.field, (Object)decisionDefinitionSearchQuerySortRequest.field) && Objects.equals((Object)this.order, (Object)decisionDefinitionSearchQuerySortRequest.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionDefinitionSearchQuerySortRequest {\n");
        sb.append("    field: ").append(this.toIndentedString((Object)this.field)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getField() != null) {
            try {
                joiner.add(String.format("%sfield%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getField()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOrder() != null) {
            try {
                joiner.add(String.format("%sorder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOrder()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum FieldEnum {
        DECISION_DEFINITION_KEY(String.valueOf("decisionDefinitionKey")),
        DECISION_DEFINITION_ID(String.valueOf("decisionDefinitionId")),
        NAME(String.valueOf("name")),
        VERSION(String.valueOf("version")),
        DECISION_REQUIREMENTS_ID(String.valueOf("decisionRequirementsId")),
        DECISION_REQUIREMENTS_KEY(String.valueOf("decisionRequirementsKey")),
        TENANT_ID(String.valueOf("tenantId")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FieldEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FieldEnum fromValue(String value) {
            for (FieldEnum b : FieldEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

