/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataSizeUtil {
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    private static final Pattern PATTERN = Pattern.compile("^(\\d+)(kb|KB|mb|MB)?$");

    private DataSizeUtil() {
    }

    public static int parse(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text must not be null");
        }
        Matcher matcher = PATTERN.matcher(text.replace(" ", ""));
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Expected %s to be a data size, but does not match pattern %s", text, PATTERN.pattern()));
        }
        String data = matcher.group(1);
        String unit = matcher.group(2);
        if (null == unit) {
            return Integer.parseInt(data);
        }
        switch (matcher.group(2).toLowerCase()) {
            case "kb": {
                return Integer.parseInt(matcher.group(1)) * 1024;
            }
            case "mb": {
                return Integer.parseInt(matcher.group(1)) * 0x100000;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected data size unit %s, should be one of [kb, mb]", unit));
    }
}

