/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.ClientFilter;
import io.camunda.client.api.search.request.ClientsByGroupSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Client;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.ClientSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.GroupClientSearchQueryRequest;
import io.camunda.client.protocol.rest.GroupClientSearchResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ClientsByGroupSearchRequestImpl
extends TypedSearchRequestPropertyProvider<GroupClientSearchQueryRequest>
implements ClientsByGroupSearchRequest {
    private final GroupClientSearchQueryRequest request;
    private final String groupId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public ClientsByGroupSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String groupId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.groupId = groupId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new GroupClientSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Client> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Client>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<SearchResponse<Client>> result = new HttpCamundaFuture<SearchResponse<Client>>();
        this.httpClient.post(String.format("/groups/%s/clients/search", this.groupId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), GroupClientSearchResult.class, SearchResponseMapper::toGroupClientsResponse, result);
        return result;
    }

    @Override
    public ClientsByGroupSearchRequest filter(ClientFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public ClientsByGroupSearchRequest filter(Consumer<ClientFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public ClientsByGroupSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)ClientsByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ClientsByGroupSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public ClientsByGroupSearchRequest sort(ClientSort value) {
        this.request.setSort(SearchRequestSortMapper.toGroupClientSearchQuerySortRequest((List)ClientsByGroupSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public ClientsByGroupSearchRequest sort(Consumer<ClientSort> fn) {
        return this.sort(SearchRequestBuilders.clientSort(fn));
    }

    @Override
    protected GroupClientSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

