/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.authentication.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public final class AuthFailureHandler
implements AuthenticationFailureHandler,
AccessDeniedHandler,
AuthenticationEntryPoint {
    private final ObjectMapper objectMapper;

    @Autowired
    public AuthFailureHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException error) throws IOException {
        this.handleFailure(request, response, HttpStatus.UNAUTHORIZED, (Exception)error);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException error) throws IOException {
        Authentication auth;
        Principal principal = request.getUserPrincipal();
        if (principal instanceof Authentication && (auth = (Authentication)principal).isAuthenticated()) {
            this.handleFailure(request, response, HttpStatus.FORBIDDEN, (Exception)error);
        }
        this.handleFailure(request, response, HttpStatus.UNAUTHORIZED, (Exception)error);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException error) throws IOException {
        this.handleFailure(request, response, HttpStatus.UNAUTHORIZED, (Exception)error);
    }

    private void handleFailure(HttpServletRequest request, HttpServletResponse response, HttpStatus status, Exception error) throws IOException {
        ProblemDetail problem = ProblemDetail.forStatus((HttpStatusCode)status);
        problem.setDetail(error.getMessage());
        problem.setInstance(URI.create(request.getRequestURI()));
        String problemDetail = this.objectMapper.writeValueAsString((Object)problem);
        response.reset();
        response.setStatus(status.value());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/problem+json");
        response.getWriter().append(problemDetail);
    }
}

