/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.authentication.config;

import io.camunda.authentication.CamundaUserDetailsService;
import io.camunda.authentication.handler.AuthFailureHandler;
import io.camunda.service.UserServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
@Profile(value={"auth-basic"})
public class WebSecurityConfig {
    public static final String[] UNAUTHENTICATED_PATHS = new String[]{"/login**", "/logout**", "/error**", "/actuator**"};
    private static final Logger LOG = LoggerFactory.getLogger(WebSecurityConfig.class);

    @Bean
    public CamundaUserDetailsService camundaUserDetailsService(UserServices userServices) {
        return new CamundaUserDetailsService(userServices);
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity) {
        try {
            return (SecurityFilterChain)httpSecurity.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    @Primary
    public HttpSecurity localHttpSecurity(HttpSecurity httpSecurity, AuthFailureHandler authFailureHandler) throws Exception {
        LOG.info("Configuring basic auth login");
        return this.baseHttpSecurity(httpSecurity, authFailureHandler).httpBasic(Customizer.withDefaults()).logout(logout -> logout.logoutSuccessUrl("/"));
    }

    private HttpSecurity baseHttpSecurity(HttpSecurity httpSecurity, AuthFailureHandler authFailureHandler) {
        try {
            return httpSecurity.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(UNAUTHENTICATED_PATHS)).permitAll().anyRequest()).authenticated()).headers(headers -> headers.httpStrictTransportSecurity(httpStrictTransportSecurity -> httpStrictTransportSecurity.includeSubDomains(true).maxAgeInSeconds(63072000L).preload(true))).exceptionHandling(exceptionHandling -> exceptionHandling.accessDeniedHandler((AccessDeniedHandler)authFailureHandler)).csrf(AbstractHttpConfigurer::disable).cors(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).anonymous(AbstractHttpConfigurer::disable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

