/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.authentication;

import io.camunda.authentication.entity.CamundaUser;
import io.camunda.service.UserServices;
import io.camunda.service.search.query.SearchQueryBuilders;
import io.camunda.service.search.query.UserQuery;
import io.camunda.util.ObjectBuilder;
import java.util.Objects;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CamundaUserDetailsService
implements UserDetailsService {
    private final UserServices userServices;

    public CamundaUserDetailsService(UserServices userServices) {
        this.userServices = userServices;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserQuery userQuery = SearchQueryBuilders.userSearchQuery(fn -> (ObjectBuilder)fn.filter(f -> f.username(username)).page(p -> p.size(Integer.valueOf(1))));
        return (UserDetails)this.userServices.search(userQuery).items().stream().filter(Objects::nonNull).findFirst().map(candidate -> CamundaUser.CamundaUserBuilder.aCamundaUser().withUserKey(candidate.key()).withName(candidate.name()).withUsername(candidate.username()).withPassword(candidate.password()).build()).orElseThrow(() -> new UsernameNotFoundException(username));
    }
}

