/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.jakarta.jsonp;

import io.burt.jmespath.BaseRuntime;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.RuntimeConfiguration;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonpRuntime
extends BaseRuntime<JsonValue> {
    private final JsonReaderFactory jsonReaderFactory;

    public JsonpRuntime() {
        this(RuntimeConfiguration.defaultConfiguration());
    }

    public JsonpRuntime(RuntimeConfiguration configuration) {
        this(configuration, Json.createReaderFactory(null));
    }

    public JsonpRuntime(RuntimeConfiguration configuration, JsonReaderFactory jsonReaderFactory) {
        super(configuration);
        this.jsonReaderFactory = jsonReaderFactory;
    }

    public JsonValue parseString(String string) {
        return this.jsonReaderFactory.createReader((Reader)new StringReader(string)).readValue();
    }

    public List<JsonValue> toList(JsonValue value) {
        JsonObject obj;
        JsonValue.ValueType valueType = value.getValueType();
        if (valueType == JsonValue.ValueType.ARRAY) {
            return new JsonArrayListWrapper((JsonArray)value);
        }
        if (valueType == JsonValue.ValueType.OBJECT && !(obj = (JsonObject)value).isEmpty()) {
            ArrayList<JsonValue> elements = new ArrayList<JsonValue>(obj.size());
            for (JsonValue v : obj.values()) {
                elements.add(this.nodeOrNullNode(v));
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public String toString(JsonValue str) {
        if (str.getValueType() == JsonValue.ValueType.STRING) {
            return ((JsonString)str).getString();
        }
        return str.toString();
    }

    public Number toNumber(JsonValue n) {
        return n.getValueType() == JsonValue.ValueType.NUMBER ? (Number)((JsonNumber)n).numberValue() : (Number)null;
    }

    public boolean isTruthy(JsonValue value) {
        switch (value.getValueType()) {
            case FALSE: 
            case NULL: {
                return false;
            }
            case NUMBER: 
            case TRUE: {
                return true;
            }
            case ARRAY: {
                return !((JsonArray)value).isEmpty();
            }
            case OBJECT: {
                return !((JsonObject)value).isEmpty();
            }
            case STRING: {
                return !((JsonString)value).getString().isEmpty();
            }
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getValueType()));
    }

    public JmesPathType typeOf(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return JmesPathType.ARRAY;
            }
            case OBJECT: {
                return JmesPathType.OBJECT;
            }
            case STRING: {
                return JmesPathType.STRING;
            }
            case FALSE: 
            case TRUE: {
                return JmesPathType.BOOLEAN;
            }
            case NULL: {
                return JmesPathType.NULL;
            }
            case NUMBER: {
                return JmesPathType.NUMBER;
            }
        }
        throw new IllegalStateException(String.format("Unknown node type encountered: %s", value.getValueType()));
    }

    public JsonValue getProperty(JsonValue value, JsonValue name) {
        if (value.getValueType() == JsonValue.ValueType.OBJECT) {
            return this.nodeOrNullNode((JsonValue)((JsonObject)value).get((Object)this.toString(name)));
        }
        return JsonValue.NULL;
    }

    public Collection<JsonValue> getPropertyNames(JsonValue value) {
        if (value.getValueType() == JsonValue.ValueType.OBJECT) {
            Set nameSet = ((JsonObject)value).keySet();
            ArrayList<JsonValue> names = new ArrayList<JsonValue>(nameSet.size());
            for (String n : nameSet) {
                names.add(this.createString(n));
            }
            return names;
        }
        return Collections.emptyList();
    }

    public JsonValue createNull() {
        return this.nodeOrNullNode(null);
    }

    public JsonValue createArray(Collection<JsonValue> elements) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (JsonValue element : elements) {
            builder.add(this.nodeOrNullNode(element));
        }
        return builder.build();
    }

    public JsonValue createString(String str) {
        return this.nodeOrNullNode((JsonValue)Json.createValue((String)str));
    }

    public JsonValue createBoolean(boolean b) {
        return b ? JsonValue.TRUE : JsonValue.FALSE;
    }

    public JsonValue createObject(Map<JsonValue, JsonValue> obj) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<JsonValue, JsonValue> entry : obj.entrySet()) {
            String key = this.toString(entry.getKey());
            if (key == null) continue;
            builder.add(key, this.nodeOrNullNode(entry.getValue()));
        }
        return builder.build();
    }

    public JsonValue createNumber(double n) {
        return Json.createValue((double)n);
    }

    public JsonValue createNumber(long n) {
        return Json.createValue((long)n);
    }

    private JsonValue nodeOrNullNode(JsonValue node) {
        if (node == null) {
            return JsonValue.NULL;
        }
        return node;
    }

    private static class JsonArrayListWrapper
    extends AbstractList<JsonValue> {
        private final JsonArray array;

        JsonArrayListWrapper(JsonArray array) {
            this.array = array;
        }

        @Override
        public JsonValue get(int index) {
            return (JsonValue)this.array.get(index);
        }

        @Override
        public int size() {
            return this.array.size();
        }
    }
}

