/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.collections;

import java.util.Arrays;
import java.util.function.IntFunction;

public final class IntObjectArrayMap<V> {
    private Object[] data;

    public IntObjectArrayMap() {
        this(16);
    }

    public IntObjectArrayMap(int initialCapacity) {
        this.data = new Object[initialCapacity];
    }

    public IntObjectArrayMap(IntObjectArrayMap<V> other) {
        this.data = Arrays.copyOf(other.data, other.data.length);
    }

    public V get(int key) {
        if (key < 0 || key >= this.data.length) {
            return null;
        }
        return (V)this.data[key];
    }

    public void put(int key, V value) {
        this.ensureCapacity(key);
        this.data[key] = value;
    }

    public V computeIfAbsent(int key, IntFunction<V> mappingFunction) {
        this.ensureCapacity(key);
        Object val = this.data[key];
        if (val == null) {
            this.data[key] = val = mappingFunction.apply(key);
        }
        return (V)val;
    }

    public void clear() {
        Arrays.fill(this.data, null);
    }

    private void ensureCapacity(int key) {
        if (key < 0) {
            throw new IllegalArgumentException("negative key: " + key);
        }
        if (key >= this.data.length) {
            int newLen;
            for (newLen = this.data.length; newLen <= key; newLen <<= 1) {
            }
            this.data = Arrays.copyOf(this.data, newLen);
        }
    }
}

