/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.Control;
import io.jafar.parser.api.EventIterator;
import io.jafar.parser.api.JafarRecordedEvent;
import io.jafar.parser.api.ParsingContext;
import io.jafar.parser.api.UntypedJafarParser;
import io.jafar.parser.api.UntypedStrategy;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class EventIteratorImpl
implements EventIterator {
    private static final JafarRecordedEvent END_MARKER = new JafarRecordedEvent(null, Collections.emptyMap(), -1L, Control.ChunkInfo.NONE);
    private final BlockingQueue<JafarRecordedEvent> queue;
    private final Thread producerThread;
    private final UntypedJafarParser parser;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile IOException parsingError = null;
    private JafarRecordedEvent next = null;
    private boolean endOfStream = false;

    public EventIteratorImpl(Path path, ParsingContext context, int bufferSize, UntypedStrategy strategy) throws IOException {
        this.queue = new ArrayBlockingQueue<JafarRecordedEvent>(bufferSize);
        this.parser = UntypedJafarParser.open(path, context, strategy);
        this.parser.handle((type, value, ctl) -> {
            try {
                JafarRecordedEvent event = new JafarRecordedEvent(type, value, ctl.stream().position(), ctl.chunkInfo());
                this.queue.put(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ctl.abort();
            }
        });
        this.producerThread = new Thread(() -> {
            try {
                this.parser.run();
                this.queue.put(END_MARKER);
            }
            catch (IOException e) {
                this.parsingError = e;
                try {
                    this.queue.put(END_MARKER);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                block18: {
                    try {
                        this.parser.close();
                    }
                    catch (Exception e) {
                        if (this.parsingError != null || !(e instanceof IOException)) break block18;
                        this.parsingError = (IOException)e;
                    }
                }
            }
        }, "jafar-event-iterator-producer");
        this.producerThread.setDaemon(false);
        this.producerThread.start();
    }

    @Override
    public boolean hasNext() {
        if (this.endOfStream) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.queue.take();
            if (this.next == END_MARKER) {
                this.endOfStream = true;
                this.next = null;
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.endOfStream = true;
            return false;
        }
    }

    @Override
    public JafarRecordedEvent next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more events available");
        }
        JafarRecordedEvent result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public IOException getParsingError() {
        return this.parsingError;
    }

    @Override
    public void close() throws IOException {
        block10: {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            if (this.producerThread.isAlive() && !this.endOfStream) {
                while (!this.endOfStream && this.producerThread.isAlive()) {
                    try {
                        JafarRecordedEvent event = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                        if (event != END_MARKER && event != null) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
            try {
                this.producerThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                this.parser.close();
            }
            catch (Exception e) {
                if (this.parsingError != null || !(e instanceof IOException) || e instanceof ClosedByInterruptException) break block10;
                this.parsingError = (IOException)e;
            }
        }
        if (this.parsingError != null && !(this.parsingError instanceof ClosedByInterruptException)) {
            throw this.parsingError;
        }
    }
}

