/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.utils;

import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.TypedParserContextFactory;
import io.jafar.parser.internal_api.ChunkParserListener;
import io.jafar.parser.internal_api.StreamingChunkParser;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataField;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.ValueDescriptor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TypeGenerator {
    private final Path jfr;
    private final Path output;
    private final String pkg;
    private final boolean overwrite;
    private final Predicate<String> eventTypeFilter;

    public TypeGenerator(Path jfr, Path output, String targetPackage, boolean overwrite, Predicate<String> eventTypeFilter) throws IOException {
        if (!Files.isDirectory(output, new LinkOption[0]) || !Files.exists(output, new LinkOption[0])) {
            throw new IllegalArgumentException("Output directory does not exist: " + String.valueOf(output));
        }
        this.jfr = jfr;
        this.pkg = targetPackage;
        this.output = output.resolve(targetPackage.replace('.', '/'));
        this.overwrite = overwrite;
        this.eventTypeFilter = eventTypeFilter;
        Files.createDirectories(this.output, new FileAttribute[0]);
    }

    public void generate() throws Exception {
        if (this.jfr == null) {
            this.generateFromRuntime();
        } else {
            this.generateFromFile();
        }
    }

    private void generateFromRuntime() throws Exception {
        HashSet generated = new HashSet();
        FlightRecorder.getFlightRecorder().getEventTypes().forEach(et -> {
            if (this.eventTypeFilter == null || this.eventTypeFilter.test(et.getName())) {
                try {
                    String className = TypeGenerator.getClassNameFromFullName(et.getName());
                    Path target = this.output.resolve(className + ".java");
                    String typeContent = this.generateTypeFromEvent((EventType)et, generated);
                    if (!Files.exists(target, new LinkOption[0])) {
                        Files.writeString(target, (CharSequence)typeContent, StandardOpenOption.CREATE_NEW);
                    } else if (this.overwrite) {
                        Files.writeString(target, (CharSequence)typeContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to generate type interface for " + et.getName(), e);
                }
            }
        });
    }

    private String generateTypeFromEvent(EventType et, Set<String> generatedTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(this.pkg).append(";\n");
        sb.append("\n");
        sb.append("import io.jafar.parser.api.*;\n");
        sb.append("@JfrType(\"").append(et.getName()).append("\")\n\n");
        String className = TypeGenerator.getClassNameFromFullName(et.getName());
        sb.append("public interface ").append(className).append(" {\n");
        et.getFields().forEach(field -> {
            String fieldTypeName;
            try {
                this.writeTypeFromField((ValueDescriptor)field, generatedTypes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String fldName = this.sanitizeFieldName(field.getName());
            sb.append('\t');
            if (!fldName.equals(field.getName())) {
                sb.append("@JfrField(\"").append(field.getName()).append("\") ");
            }
            if (TypeGenerator.isPrimitiveName(fieldTypeName = field.getTypeName())) {
                sb.append(fieldTypeName);
            } else {
                sb.append(TypeGenerator.getClassNameFromFullName(fieldTypeName));
            }
            if (field.isArray()) {
                sb.append("[]");
            }
            sb.append(" ");
            sb.append(fldName).append("();\n");
        });
        sb.append("}\n");
        return sb.toString();
    }

    private void writeTypeFromField(ValueDescriptor f, Set<String> generatedTypes) throws Exception {
        String data = this.getTypeFromField(f, generatedTypes);
        if (data != null) {
            String typeName = f.getTypeName();
            String targetName = TypeGenerator.isPrimitiveName(typeName) ? typeName : TypeGenerator.getClassNameFromFullName(typeName);
            Path target = this.output.resolve(targetName + ".java");
            if (!Files.exists(target, new LinkOption[0])) {
                Files.writeString(target, (CharSequence)data, StandardOpenOption.CREATE_NEW);
            } else if (this.overwrite) {
                Files.writeString(target, (CharSequence)data, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }

    private String getTypeFromField(ValueDescriptor field, Set<String> generatedTypes) {
        String typeName = field.getTypeName();
        if (TypeGenerator.isPrimitiveName(typeName)) {
            return null;
        }
        if (generatedTypes.add(typeName)) {
            StringBuilder sb = new StringBuilder();
            sb.append("package ").append(this.pkg).append(";\n");
            sb.append("\n");
            sb.append("import io.jafar.parser.api.*;\n");
            sb.append("@JfrType(\"").append(typeName).append("\")\n\n");
            String className = TypeGenerator.getClassNameFromFullName(typeName);
            sb.append("public interface ").append(className).append(" {\n");
            field.getFields().forEach(subfield -> {
                String subfieldTypeName;
                try {
                    this.writeTypeFromField((ValueDescriptor)subfield, generatedTypes);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                String fldName = this.sanitizeFieldName(subfield.getName());
                sb.append('\t');
                if (!fldName.equals(subfield.getName())) {
                    sb.append("@JfrField(\"").append(subfield.getName()).append("\") ");
                }
                if (TypeGenerator.isPrimitiveName(subfieldTypeName = subfield.getTypeName())) {
                    sb.append(subfieldTypeName);
                } else {
                    sb.append(TypeGenerator.getClassNameFromFullName(subfieldTypeName));
                }
                if (subfield.isArray()) {
                    sb.append("[]");
                }
                sb.append(" ");
                sb.append(fldName).append("();\n");
            });
            sb.append("}\n");
            return sb.toString();
        }
        return null;
    }

    private void generateFromFile() throws Exception {
        final HashSet processed = new HashSet();
        try (StreamingChunkParser parser = new StreamingChunkParser(new TypedParserContextFactory(null));){
            parser.parse(this.jfr, new ChunkParserListener(){

                @Override
                public boolean onMetadata(ParserContext context, MetadataEvent metadata) {
                    metadata.getClasses().stream().filter(clz -> {
                        boolean isEv = TypeGenerator.isEvent(clz);
                        boolean passesFilter = TypeGenerator.this.eventTypeFilter == null || TypeGenerator.this.eventTypeFilter.test(clz.getName());
                        return isEv && passesFilter;
                    }).forEach(clz -> TypeGenerator.this.writeClass((MetadataClass)clz, processed));
                    return false;
                }
            });
        }
    }

    private void writeClass(MetadataClass metadataClass, Set<String> processed) {
        if (metadataClass.isPrimitive()) {
            return;
        }
        if (TypeGenerator.isAnnotation(metadataClass) || TypeGenerator.isSettingControl(metadataClass)) {
            return;
        }
        if (!processed.add(metadataClass.getName())) {
            return;
        }
        try {
            Path classFile = this.output.resolve(this.getClassName(metadataClass) + ".java");
            String classContent = this.generateClass(metadataClass, processed);
            if (!Files.exists(classFile, new LinkOption[0])) {
                Files.writeString(classFile, (CharSequence)classContent, StandardOpenOption.CREATE_NEW);
            } else if (this.overwrite) {
                Files.writeString(classFile, (CharSequence)classContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String generateClass(MetadataClass clazz, Set<String> processed) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(this.pkg).append(";\n");
        sb.append("\n");
        sb.append("import io.jafar.parser.api.*;\n");
        sb.append("@JfrType(\"").append(clazz.getName()).append("\")\n\n");
        sb.append("public interface ").append(this.getClassName(clazz));
        sb.append(" {\n");
        for (MetadataField field : clazz.getFields()) {
            String fldName = this.sanitizeFieldName(field.getName());
            sb.append('\t');
            if (!fldName.equals(field.getName())) {
                sb.append("@JfrField(\"").append(field.getName()).append("\") ");
            }
            MetadataClass fldType = field.getType();
            while (fldType.isSimpleType()) {
                fldType = fldType.getFields().getFirst().getType();
            }
            if (!fldType.isPrimitive() && !processed.contains(fldType.getName())) {
                this.writeClass(fldType, processed);
            }
            sb.append(this.getClassName(fldType));
            sb.append("[]".repeat(Math.max(0, field.getDimension())));
            sb.append(" ");
            sb.append(fldName).append("();\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String getClassName(MetadataClass clazz) {
        if (clazz.isPrimitive()) {
            return clazz.getSimpleName();
        }
        String fullName = clazz.getName();
        String className = fullName.replace('.', '_');
        StringBuilder result = new StringBuilder("JFR");
        boolean capitalizeNext = true;
        for (char c : className.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            result.append(capitalizeNext ? Character.toUpperCase(c) : c);
            capitalizeNext = false;
        }
        return result.toString();
    }

    private String sanitizeFieldName(String fieldName) {
        String sanitized = fieldName;
        switch (sanitized = sanitized.replace('.', '_')) {
            case "class": {
                return "clz";
            }
            case "package": {
                return "pkg";
            }
        }
        return sanitized;
    }

    private static boolean isEvent(MetadataClass clazz) {
        String superType = clazz.getSuperType();
        if (superType == null) {
            return false;
        }
        return "jdk.jfr.Event".equals(superType);
    }

    private static boolean isAnnotation(MetadataClass clazz) {
        String superType = clazz.getSuperType();
        if (superType == null) {
            return false;
        }
        return "java.lang.annotation.Annotation".equals(superType);
    }

    private static boolean isSettingControl(MetadataClass clazz) {
        String superType = clazz.getSuperType();
        if (superType == null) {
            return false;
        }
        return "jdk.jfr.SettingControl".equals(superType);
    }

    private static String getSimpleName(String name) {
        int idx = name.lastIndexOf(46);
        return idx == -1 ? name : name.substring(idx + 1);
    }

    private static String getClassNameFromFullName(String fullName) {
        String className = fullName.replace('.', '_');
        StringBuilder result = new StringBuilder("JFR");
        boolean capitalizeNext = true;
        for (char c : className.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            result.append(capitalizeNext ? Character.toUpperCase(c) : c);
            capitalizeNext = false;
        }
        return result.toString();
    }

    private static boolean isPrimitiveName(String name) {
        return name.lastIndexOf(46) == -1 || "java.lang.String".equals(name);
    }
}

