/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.api.MetadataLookup;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class MutableMetadataLookup
implements MetadataLookup {
    private String[] strings;
    private final Long2ObjectMap<MetadataClass> classes = new Long2ObjectOpenHashMap();
    private final Map<String, MetadataClass> classesByName = new HashMap<String, MetadataClass>();

    @Override
    public String getString(int idx) {
        if (this.strings == null || idx < 0 || idx >= this.strings.length) {
            throw new IllegalArgumentException(String.format("String index %d out of bounds (string table size: %d)", idx, this.strings == null ? 0 : this.strings.length));
        }
        return this.strings[idx];
    }

    @Override
    public MetadataClass getClass(long id) {
        return (MetadataClass)this.classes.get(id);
    }

    @Override
    public MetadataClass getClass(String name) {
        return this.classesByName.get(name);
    }

    public MetadataClass addClass(long id, MetadataClass clazz) {
        MetadataClass rslt = (MetadataClass)this.classes.get(id);
        if (rslt == null) {
            rslt = clazz;
            this.classes.put(id, (Object)clazz);
            this.classesByName.put(rslt.getName(), clazz);
        }
        return rslt;
    }

    public void setStringtable(String[] stringTable) {
        this.strings = Arrays.copyOf(stringTable, stringTable.length);
    }

    public void bindDeserializers() {
        for (MetadataClass clazz : this.classes.values()) {
            clazz.bindDeserializer();
        }
    }

    public void clear() {
        this.strings = null;
        this.classes.clear();
        this.classesByName.clear();
    }
}

