/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.ArrayHolder;
import io.jafar.parser.impl.ConstantPoolAccessor;
import io.jafar.parser.impl.MultiTypeStack;
import io.jafar.parser.internal_api.ValueProcessor;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import java.util.HashMap;
import java.util.Map;

public final class MapValueBuilder
implements ValueProcessor {
    private final ParserContext context;
    private final MultiTypeStack stack = new MultiTypeStack(20);
    private Map<String, Object> root;

    public MapValueBuilder(ParserContext context) {
        this.context = context;
    }

    void reset() {
        this.root = null;
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }

    @Override
    public void onStringValue(MetadataClass owner, String fld, String value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, value);
        }
    }

    @Override
    public void onShortValue(MetadataClass type, String fld, short value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, value);
        }
    }

    @Override
    public void onCharValue(MetadataClass type, String fld, char value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(Character.valueOf(value));
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, Character.valueOf(value));
        }
    }

    @Override
    public void onIntValue(MetadataClass owner, String fld, long value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, value);
        }
    }

    @Override
    public void onLongValue(MetadataClass type, String fld, long value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, value);
        }
    }

    @Override
    public void onByteValue(MetadataClass type, String fld, byte value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, value);
        }
    }

    @Override
    public void onBooleanValue(MetadataClass owner, String fld, boolean value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, value);
        }
    }

    @Override
    public void onDoubleValue(MetadataClass owner, String fld, double value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, value);
        }
    }

    @Override
    public void onFloatValue(MetadataClass owner, String fld, float value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(Float.valueOf(value));
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, Float.valueOf(value));
        }
    }

    @Override
    public void onComplexValueStart(MetadataClass owner, String fld, MetadataClass type) {
        HashMap value = new HashMap();
        this.stack.push(value);
    }

    @Override
    public void onComplexValueEnd(MetadataClass owner, String fld, MetadataClass type) {
        Map value = this.stack.pop(Map.class);
        assert (value != null);
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else if (owner != null && fld != null) {
            Map parent = this.stack.peek(Map.class);
            if (parent != null) {
                parent.put(fld, value);
            }
        } else {
            this.root = value;
        }
    }

    @Override
    public void onArrayStart(MetadataClass owner, String fld, MetadataClass type, int len) {
        ArrayHolder arr = new ArrayHolder(type.getName(), len);
        this.stack.push(arr);
    }

    @Override
    public void onArrayEnd(MetadataClass owner, String fld, MetadataClass type) {
        ArrayHolder arr = this.stack.pop(ArrayHolder.class);
        assert (arr != null);
        Map parent = this.stack.peek(Map.class);
        assert (parent != null);
        parent.put(fld, arr);
    }

    @Override
    public void onConstantPoolIndex(MetadataClass owner, String fld, MetadataClass type, long pointer) {
        ConstantPoolAccessor cpAccessor = new ConstantPoolAccessor(this.context, type, pointer);
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(cpAccessor);
        } else {
            Map parent = this.stack.peek(Map.class);
            assert (parent != null);
            parent.put(fld, cpAccessor);
        }
    }
}

