/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api.metadata;

import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.metadata.AbstractMetadataElement;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataElementKind;
import io.jafar.parser.internal_api.metadata.MetadataEvent;
import io.jafar.parser.internal_api.metadata.MetadataVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class MetadataElement
extends AbstractMetadataElement {
    private boolean hasHashCode = false;
    private int hashCode;
    private List<MetadataClass> classes = null;

    MetadataElement(RecordingStream stream, MetadataEvent event) throws IOException {
        super(stream, MetadataElementKind.META);
        this.readSubelements(event);
    }

    @Override
    protected void onSubelement(int count, AbstractMetadataElement element) {
        if (element.getKind() == MetadataElementKind.CLASS) {
            if (this.classes == null) {
                this.classes = new ArrayList<MetadataClass>(count);
            }
        } else {
            throw new IllegalStateException("Unexpected subelement: " + (Object)((Object)element.getKind()));
        }
        MetadataClass clz = (MetadataClass)element;
        this.classes.add(clz);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visitMetadata(this);
        if (this.classes != null) {
            this.classes.forEach(c -> c.accept(visitor));
        }
    }

    public String toString() {
        return "MetadataElement";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataElement that = (MetadataElement)o;
        return Objects.equals(this.classes, that.classes);
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hashCode = Objects.hash(this.classes);
            this.hasHashCode = true;
        }
        return this.hashCode;
    }
}

