/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn.overlay;

import clocker.docker.entity.DockerHost;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProviderImpl;
import clocker.docker.networking.entity.sdn.overlay.OverlayNetwork;
import clocker.docker.networking.entity.sdn.overlay.OverlayPlugin;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.jclouds.net.domain.IpPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlayNetworkImpl
extends SdnProviderImpl
implements OverlayNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(OverlayNetwork.class);

    @Override
    public void init() {
        LOG.info("Starting Overlay network id {}", (Object)this.getId());
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)SDN_AGENT_SPEC);
    }

    public String getIconUrl() {
        return "classpath://docker-logo.png";
    }

    @Override
    public Collection<IpPermission> getIpPermissions(String source) {
        MutableList permissions = MutableList.of();
        return permissions;
    }

    @Override
    public InetAddress getNextAgentAddress(String agentId) {
        Entity agent = this.getManagementContext().getEntityManager().getEntity(agentId);
        String address = (String)((DockerHost)agent.sensors().get((AttributeSensor)OverlayPlugin.DOCKER_HOST)).sensors().get(Attributes.SUBNET_ADDRESS);
        try {
            return InetAddress.getByName(address);
        }
        catch (UnknownHostException uhe) {
            throw Exceptions.propagate((Throwable)uhe);
        }
    }

    @Override
    public void addHost(DockerHost host) {
        SshMachineLocation machine = ((DockerHostLocation)host.getDynamicLocation()).getMachine();
        EntitySpec spec = (EntitySpec)((EntitySpec)EntitySpec.create((EntitySpec)((EntitySpec)this.sensors().get((AttributeSensor)SDN_AGENT_SPEC))).configure((ConfigKey.HasConfigKey)OverlayPlugin.SDN_PROVIDER, (Object)this)).configure((ConfigKey.HasConfigKey)OverlayPlugin.DOCKER_HOST, (Object)host);
        OverlayPlugin agent = (OverlayPlugin)this.getAgents().addChild(spec);
        this.getAgents().addMember((Entity)agent);
        agent.start((Collection)ImmutableList.of((Object)machine));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added overlay plugin {}", (Object)this, (Object)agent);
        }
    }

    @Override
    public void removeHost(DockerHost host) {
        SdnAgent agent = (SdnAgent)host.sensors().get(SdnAgent.SDN_AGENT);
        if (agent == null) {
            LOG.warn("{} cannot find overlay service: {}", (Object)this, (Object)host);
            return;
        }
        agent.stop();
        this.getAgents().removeMember((Entity)agent);
        Entities.unmanage((Entity)agent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} removed overlay plugin {}", (Object)this, (Object)agent);
        }
    }
}

