/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn.calico;

import clocker.docker.networking.entity.sdn.DockerNetworkAgentSshDriver;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.calico.CalicoNetwork;
import clocker.docker.networking.entity.sdn.calico.CalicoNode;
import clocker.docker.networking.entity.sdn.calico.CalicoNodeDriver;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import io.brooklyn.entity.nosql.etcd.EtcdNode;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalicoNodeSshDriver
extends DockerNetworkAgentSshDriver
implements CalicoNodeDriver {
    private static final Logger LOG = LoggerFactory.getLogger(CalicoNode.class);

    public CalicoNodeSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    public String getDockerNetworkDriver() {
        return "calico";
    }

    public void postLaunch() {
    }

    public String getCalicoCommand() {
        return Os.mergePathsUnix((String[])new String[]{this.getInstallDir(), "calicoctl"});
    }

    public void install() {
        LinkedList commands = Lists.newLinkedList();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)this.resolver.getTargets(), (String)this.getCalicoCommand()));
        commands.add("chmod 755 " + this.getCalicoCommand());
        commands.add(BashCommands.installPackage((String)"ipset"));
        commands.add(BashCommands.sudo((String)"modprobe ip6_tables"));
        commands.add(BashCommands.sudo((String)"modprobe xt_set"));
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript("customizing").execute();
    }

    public void launch() {
        InetAddress address = (InetAddress)this.getEntity().sensors().get(SdnAgent.SDN_AGENT_ADDRESS);
        Boolean firstMember = (Boolean)this.getEntity().sensors().get(AbstractGroup.FIRST_MEMBER);
        LOG.info("Launching {} calico service at {}", (Object)(Boolean.TRUE.equals(firstMember) ? "first" : "next"), (Object)address.getHostAddress());
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)BashCommands.sudo((String)String.format("%s node --libnetwork --ip=%s", this.getCalicoCommand(), address.getHostAddress()))).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)BashCommands.sudo((String)String.format("%s status", this.getCalicoCommand()))).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)BashCommands.sudo((String)(this.getCalicoCommand() + " node stop --force"))).execute();
    }

    @Override
    public List<String> getDockerNetworkCreateOpts() {
        boolean ipip = (Boolean)this.entity.config().get(CalicoNetwork.USE_IPIP);
        boolean nat = (Boolean)this.entity.config().get(CalicoNetwork.USE_NAT);
        MutableList opts = MutableList.copyOf(super.getDockerNetworkCreateOpts());
        if (ipip) {
            opts.add("ipip=true");
        }
        if (nat) {
            opts.add("nat-outgoing=true");
        }
        return opts;
    }

    @Override
    public void createSubnet(String subnetId, Cidr subnetCidr) {
        boolean ipip = (Boolean)this.entity.config().get(CalicoNetwork.USE_IPIP);
        boolean nat = (Boolean)this.entity.config().get(CalicoNetwork.USE_NAT);
        this.newScript((String)"createSubnet").body.append((CharSequence)BashCommands.sudo((String)String.format("%s pool add %s %s %s", this.getCalicoCommand(), subnetCidr, ipip ? "--ipip" : "", nat ? "--nat-outgoing" : ""))).execute();
        super.createSubnet(subnetId, subnetCidr);
    }

    public Map<String, String> getShellEnvironment() {
        Entity etcdNode = (Entity)this.getEntity().config().get(CalicoNode.ETCD_NODE);
        HostAndPort etcdAuthority = HostAndPort.fromParts((String)((String)etcdNode.sensors().get(Attributes.SUBNET_ADDRESS)), (int)((Integer)etcdNode.sensors().get((AttributeSensor)EtcdNode.ETCD_CLIENT_PORT)));
        MutableMap environment = MutableMap.copyOf((Map)super.getShellEnvironment());
        environment.put("ETCD_AUTHORITY", etcdAuthority.toString());
        return environment;
    }
}

