/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity;

import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.location.NetworkProvisioningExtension;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.entity.stock.BasicStartableImpl;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNetworkImpl
extends BasicStartableImpl
implements VirtualNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualNetwork.class);

    public void init() {
        LOG.info("Starting virtual network segment id {}", (Object)this.getId());
        super.init();
        String networkId = (String)this.config().get((ConfigKey.HasConfigKey)NETWORK_ID);
        if (Strings.isEmpty((CharSequence)networkId)) {
            networkId = this.getId();
        }
        this.sensors().set((AttributeSensor)NETWORK_ID, (Object)networkId);
        this.setDisplayName(String.format("Virtual Network (%s)", networkId));
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)SDN_PROVIDER);
    }

    public void start(Collection<? extends Location> locs) {
        this.addLocations(locs);
        MutableList locations = MutableList.copyOf((Iterable)Locations.getLocationsCheckingAncestors(locs, (Entity)this));
        this.sensors().set(SERVICE_UP, (Object)Boolean.FALSE);
        super.start((Collection)locations);
        try {
            NetworkProvisioningExtension provisioner = null;
            Entity sdn = (Entity)this.sensors().get((AttributeSensor)SDN_PROVIDER);
            provisioner = sdn instanceof NetworkProvisioningExtension ? (NetworkProvisioningExtension)sdn : this.findNetworkProvisioner((Collection<? extends Location>)locations);
            this.sensors().set(NETWORK_PROVISIONER, (Object)provisioner);
            provisioner.provisionNetwork(this);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
        this.sensors().set(SERVICE_UP, (Object)Boolean.TRUE);
    }

    public NetworkProvisioningExtension findNetworkProvisioner(Collection<? extends Location> locations) {
        Optional found = Iterables.tryFind(locations, (Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input.hasExtension(NetworkProvisioningExtension.class);
            }
        });
        if (!found.isPresent()) {
            throw new IllegalStateException("Cannot start a virtual network in any location: " + Iterables.toString((Iterable)this.getLocations()));
        }
        NetworkProvisioningExtension provisioner = (NetworkProvisioningExtension)((Location)found.get()).getExtension(NetworkProvisioningExtension.class);
        return provisioner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.sensors().set(SERVICE_UP, (Object)Boolean.FALSE);
        VirtualNetworkImpl virtualNetworkImpl = this;
        synchronized (virtualNetworkImpl) {
            try {
                Tasks.setBlockingDetails((String)("Waiting until all containers are disconnected from " + (String)this.sensors().get((AttributeSensor)NETWORK_ID)));
                Task waiting = DependentConfiguration.attributeWhenReady((Entity)this, (AttributeSensor)CONNECTED_CONTAINERS, (Predicate)new Predicate<Set>(){

                    public boolean apply(Set input) {
                        return input.isEmpty();
                    }
                });
                Task task = DynamicTasks.queueIfPossible((TaskAdaptable)waiting).orSubmitAndBlock((Entity)this).asTask();
                task.get(Duration.FIVE_MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.error("Error waiting for containers to disconnect", (Throwable)e);
                throw Exceptions.propagate((Throwable)e);
            }
            finally {
                Tasks.resetBlockingDetails();
            }
            NetworkProvisioningExtension provisioner = (NetworkProvisioningExtension)this.sensors().get(NETWORK_PROVISIONER);
            if (provisioner != null) {
                provisioner.deallocateNetwork(this);
            }
            super.stop();
        }
    }

    static {
        RendererHints.register(Cidr.class, (RendererHints.Hint)RendererHints.displayValue((Function)StringFunctions.toStringFunction()));
    }
}

