/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity;

import clocker.docker.networking.entity.OpenStackVirtualNetwork;
import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.entity.VirtualNetworkImpl;
import clocker.docker.networking.location.NetworkProvisioningExtension;
import clocker.docker.networking.location.OpenStackNetworkProvisioner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStackVirtualNetworkImpl
extends VirtualNetworkImpl
implements OpenStackVirtualNetwork {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualNetwork.class);

    @Override
    public void init() {
        LOG.info("Starting openstack network segment id {}", (Object)this.getId());
        super.init();
    }

    @Override
    public NetworkProvisioningExtension findNetworkProvisioner(Collection<? extends Location> locations) {
        Optional found = Iterables.tryFind(locations, (Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input instanceof JcloudsLocation && ((JcloudsLocation)input).getProvider().startsWith("openstack");
            }
        });
        if (!found.isPresent()) {
            throw new IllegalStateException("Cannot find openstack location: " + Iterables.toString((Iterable)this.getLocations()));
        }
        JcloudsLocation provisioner = (JcloudsLocation)found.get();
        OpenStackNetworkProvisioner extension = new OpenStackNetworkProvisioner(provisioner);
        return extension;
    }
}

