/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location.strategy.basic;

import clocker.docker.location.DockerHostLocation;
import clocker.docker.location.strategy.BasicDockerPlacementStrategy;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostnamePlacementStrategy
extends BasicDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(HostnamePlacementStrategy.class);
    @SetFromFlag(value="hostname")
    public static final ConfigKey<String> HOSTNAME_PATTERN = ConfigKeys.newStringConfigKey((String)"docker.constraint.hostname", (String)"The pattern the required hostname must match");

    @Override
    public boolean apply(DockerHostLocation input) {
        String constraint = (String)Preconditions.checkNotNull((Object)this.config().get(HOSTNAME_PATTERN), (Object)"pattern");
        String hostname = Strings.nullToEmpty((String)input.getMachine().getHostname());
        boolean match = hostname.matches(constraint);
        LOG.debug("Hostname {} {} {}", new Object[]{hostname, match ? "matches" : "not", constraint});
        return match;
    }
}

