/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container.application;

import clocker.docker.entity.container.application.VanillaDockerApplicationDriver;
import clocker.docker.entity.container.application.VanillaDockerApplicationImpl;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.VanillaSoftwareProcess;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaDockerApplicationSshDriver
extends AbstractSoftwareProcessSshDriver
implements VanillaDockerApplicationDriver {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaDockerApplicationSshDriver.class);

    public VanillaDockerApplicationSshDriver(VanillaDockerApplicationImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public Entity getOwnerEntity() {
        return ((DynamicLocation)this.getMachine()).getOwner();
    }

    public boolean isRunning() {
        String customCommand = (String)this.getEntity().config().get(VanillaSoftwareProcess.CHECK_RUNNING_COMMAND);
        if (Strings.isBlank((CharSequence)customCommand)) {
            return (Boolean)this.getOwnerEntity().sensors().get(Startable.SERVICE_UP);
        }
        return this.newScript((String)"check-running").body.append((CharSequence)customCommand).execute() == 0;
    }

    public void stop() {
        Entities.invokeEffector((Entity)this.getEntity(), (Entity)this.getOwnerEntity(), (Effector)Startable.STOP);
    }

    public void install() {
        LOG.info("Container installed on {}", (Object)this.getOwnerEntity());
    }

    public void copyRuntimeResources() {
        Map runtimeFiles = (Map)this.entity.getConfig((ConfigKey)VanillaSoftwareProcess.RUNTIME_FILES);
        Map runtimeTemplates = (Map)this.entity.getConfig((ConfigKey)VanillaSoftwareProcess.RUNTIME_TEMPLATES);
        if (runtimeFiles != null && runtimeFiles.size() > 0 || runtimeTemplates != null && runtimeTemplates.size() > 0) {
            super.copyRuntimeResources();
        }
    }

    public void customize() {
        String customizeCommand = (String)this.getEntity().config().get(VanillaSoftwareProcess.CUSTOMIZE_COMMAND);
        if (Strings.isNonBlank((CharSequence)customizeCommand)) {
            this.newScript((String)"customizing").failOnNonZeroResultCode().body.append((CharSequence)customizeCommand).execute();
        }
    }

    public void launch() {
        String launchCommand = (String)this.getEntity().config().get(VanillaSoftwareProcess.LAUNCH_COMMAND);
        if (Strings.isNonBlank((CharSequence)launchCommand)) {
            this.newScript((String)"launching").failOnNonZeroResultCode().body.append((CharSequence)launchCommand).execute();
        }
    }
}

