/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn.weave;

import clocker.docker.entity.DockerHost;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.networking.entity.sdn.DockerNetworkAgentSshDriver;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProvider;
import clocker.docker.networking.entity.sdn.weave.WeaveRouter;
import clocker.docker.networking.entity.sdn.weave.WeaveRouterDriver;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeaveRouterSshDriver
extends DockerNetworkAgentSshDriver
implements WeaveRouterDriver {
    private static final Logger LOG = LoggerFactory.getLogger(WeaveRouter.class);

    public WeaveRouterSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    public String getDockerNetworkDriver() {
        return "weave";
    }

    public String getWeaveCommand() {
        return Os.mergePathsUnix((String[])new String[]{this.getInstallDir(), "weave"});
    }

    public void install() {
        LinkedList commands = Lists.newLinkedList();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)this.resolver.getTargets(), (String)this.getWeaveCommand()));
        commands.add("chmod 755 " + this.getWeaveCommand());
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript("customizing").execute();
    }

    public void launch() {
        InetAddress address = (InetAddress)this.getEntity().sensors().get(WeaveRouter.SDN_AGENT_ADDRESS);
        Boolean firstMember = (Boolean)this.getEntity().sensors().get(AbstractGroup.FIRST_MEMBER);
        Entity first = (Entity)this.getEntity().sensors().get(AbstractGroup.FIRST);
        LOG.info("Launching {} Weave service at {}", (Object)(Boolean.TRUE.equals(firstMember) ? "first" : "next"), (Object)address.getHostAddress());
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append((CharSequence)BashCommands.chain((String[])new String[]{BashCommands.sudo((String)String.format("%s launch-router --ipalloc-range %s %s", this.getWeaveCommand(), this.entity.config().get(SdnProvider.CONTAINER_NETWORK_CIDR), Boolean.TRUE.equals(firstMember) ? "" : (String)first.sensors().get(Attributes.SUBNET_ADDRESS))), BashCommands.sudo((String)String.format("%s launch-plugin", this.getWeaveCommand()))})).failOnNonZeroResultCode().uniqueSshConnection().execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        ((DockerHostLocation)((DockerHost)this.getEntity().sensors().get(SdnAgent.DOCKER_HOST)).getDynamicLocation()).getLock().lock();
        try {
            boolean bl = this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)BashCommands.sudo((String)(this.getWeaveCommand() + " status"))).execute() == 0;
            return bl;
        }
        finally {
            ((DockerHostLocation)((DockerHost)this.getEntity().sensors().get(SdnAgent.DOCKER_HOST)).getDynamicLocation()).getLock().unlock();
        }
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)BashCommands.sudo((String)(this.getWeaveCommand() + " stop"))).execute();
    }

    public Map<String, String> getShellEnvironment() {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"CHECKPOINT_DISABLE", (Object)"1").put((Object)"WEAVE_VERSION", this.entity.config().get(WeaveRouter.SUGGESTED_VERSION)).put((Object)"VERSION", this.entity.config().get(WeaveRouter.SUGGESTED_VERSION));
        return builder.build();
    }
}

