/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn;

import clocker.docker.entity.DockerHost;
import clocker.docker.networking.entity.sdn.DockerNetworkAgentDriver;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnProvider;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.List;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.text.StringFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DockerNetworkAgentSshDriver
extends AbstractSoftwareProcessSshDriver
implements DockerNetworkAgentDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SdnAgent.class);

    public DockerNetworkAgentSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    public List<String> getDockerNetworkCreateOpts() {
        MutableList opts = MutableList.of();
        return opts;
    }

    @Override
    public void createSubnet(String subnetId, Cidr subnetCidr) {
        Iterable opts = Iterables.transform(this.getDockerNetworkCreateOpts(), (Function)StringFunctions.prepend((String)"--opt "));
        ((DockerHost)this.getEntity().sensors().get(SdnAgent.DOCKER_HOST)).runDockerCommand(String.format("network create --driver %s %s --subnet=%s %s", this.getDockerNetworkDriver(), Joiner.on((char)' ').join(opts), subnetCidr, subnetId));
    }

    @Override
    public void deleteSubnet(String subnetId) {
        ((DockerHost)this.getEntity().sensors().get(SdnAgent.DOCKER_HOST)).runDockerCommand(String.format("network rm %s", subnetId));
    }

    @Override
    public InetAddress attachNetwork(String containerId, String subnetId) {
        ((DockerHost)this.getEntity().sensors().get(SdnAgent.DOCKER_HOST)).runDockerCommand(String.format("network connect %s %s", subnetId, containerId));
        String ip = ((DockerHost)this.getEntity().sensors().get(SdnAgent.DOCKER_HOST)).runDockerCommand(String.format("inspect --format \"{{ .NetworkSettings.Networks.%s.IPAddress }}\" %s", subnetId, containerId));
        InetAddress address = Networking.getInetAddressWithFixedName((String)ip);
        ((SdnProvider)this.getEntity().sensors().get(SdnAgent.SDN_PROVIDER)).recordContainerAddress(subnetId, address);
        ((SdnProvider)this.getEntity().sensors().get(SdnAgent.SDN_PROVIDER)).associateContainerAddress(containerId, address);
        return address;
    }
}

