/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location.strategy.affinity;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.reflect.TypeToken;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.util.javalang.Reflections;

public class AffinityRules
implements Predicate<Entity> {
    public static final ConfigKey<List<String>> AFFINITY_RULES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"affinity.rules", (String)"Affinity rules for entity placemnent");
    public static final String NOT = "NOT";
    public static final String TYPE = "TYPE";
    public static final String NAME = "NAME";
    public static final String ID = "ID";
    public static final String APPLICATION = "APPLICATION";
    public static final String PREDICATE = "PREDICATE";
    public static final String EMPTY = "EMPTY";
    public static final Iterable<String> VERBS = ImmutableList.of((Object)"TYPE", (Object)"NAME", (Object)"ID", (Object)"APPLICATION", (Object)"PREDICATE", (Object)"EMPTY");
    private Predicate<Entity> affinityRules = Predicates.alwaysTrue();
    private boolean allowEmpty = true;
    private final Entity entity;

    private AffinityRules(Entity entity) {
        this.entity = entity;
    }

    public static AffinityRules rulesFor(Entity entity) {
        return new AffinityRules(entity);
    }

    public AffinityRules parse(String ... rules) {
        return this.parse((Iterable<String>)ImmutableList.copyOf((Object[])rules));
    }

    public AffinityRules parse(String rules) {
        return this.parse(Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\n,")).omitEmptyStrings().split((CharSequence)rules));
    }

    public AffinityRules parse(Iterable<String> rules) {
        ArrayList predicates = Lists.newArrayList();
        for (String rule : rules) {
            Predicate<Entity> predicate = this.predicate(rule);
            predicates.add(predicate);
        }
        this.affinityRules = Predicates.and((Iterable)predicates);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Predicate<Entity> predicate(String rule) {
        String verb;
        Preconditions.checkNotNull((Object)rule, (Object)"rule");
        ArrayDeque tokens = Queues.newArrayDeque((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().splitToList((CharSequence)rule));
        boolean same = true;
        Predicate predicate = Predicates.alwaysTrue();
        String first = (String)tokens.peek();
        if (first.equalsIgnoreCase(NOT)) {
            same = false;
            tokens.remove();
        }
        if ((verb = (String)tokens.peek()) == null) {
            throw new IllegalStateException("Affinity rule verb not specified: " + rule);
        }
        if (!Iterables.contains(VERBS, (Object)verb.toUpperCase(Locale.ENGLISH))) {
            throw new IllegalStateException("Affinity rule parser found unexpected verb token: " + verb);
        }
        tokens.remove();
        final String parameter = (String)tokens.peek();
        if (parameter == null) {
            if (verb.equalsIgnoreCase(EMPTY)) {
                this.allowEmpty = same;
                tokens.remove();
                if (!tokens.isEmpty()) throw new IllegalStateException("Affinity rule has extra tokens: " + rule);
                return predicate;
            }
            if (verb.equalsIgnoreCase(TYPE)) {
                predicate = new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity input) {
                        return input.getEntityType().getName().equalsIgnoreCase(AffinityRules.this.entity.getEntityType().getName()) || input.getEntityType().getSimpleName().equalsIgnoreCase(AffinityRules.this.entity.getEntityType().getSimpleName());
                    }
                };
            } else if (verb.equalsIgnoreCase(ID)) {
                predicate = EntityPredicates.idEqualTo((String)this.entity.getId());
            } else {
                if (!verb.equalsIgnoreCase(APPLICATION)) throw new IllegalStateException("Affinity rule parameter not specified: " + rule);
                predicate = EntityPredicates.applicationIdEqualTo((String)this.entity.getApplicationId());
            }
        } else {
            tokens.remove();
            if (verb.equalsIgnoreCase(TYPE)) {
                predicate = new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity input) {
                        return input.getEntityType().getName().equalsIgnoreCase(parameter) || input.getEntityType().getSimpleName().equalsIgnoreCase(parameter);
                    }
                };
            } else if (verb.equalsIgnoreCase(NAME)) {
                predicate = new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity input) {
                        return input.getDisplayName().toLowerCase(Locale.ENGLISH).contains(parameter.toLowerCase(Locale.ENGLISH));
                    }
                };
            } else if (verb.equalsIgnoreCase(ID)) {
                predicate = EntityPredicates.idEqualTo((String)parameter);
            } else if (verb.equalsIgnoreCase(APPLICATION)) {
                predicate = EntityPredicates.applicationIdEqualTo((String)parameter);
            } else if (verb.equalsIgnoreCase(PREDICATE)) {
                try {
                    Class<?> clazz = Class.forName(parameter);
                    if (!Reflections.hasNoArgConstructor(clazz)) {
                        throw new IllegalStateException("Could not instantiate predicate: " + parameter);
                    }
                    predicate = (Predicate)Reflections.invokeConstructorWithArgs(clazz, (Object[])new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Could not find predicate: " + parameter);
                }
            }
        }
        if (tokens.peek() != null) {
            throw new IllegalStateException("Affinity rule has extra tokens: " + rule);
        }
        if (!same) return Predicates.not((Predicate)predicate);
        return predicate;
    }

    public boolean apply(@Nullable Entity input) {
        return this.affinityRules.apply((Object)input);
    }

    public boolean allowEmptyLocations() {
        return this.allowEmpty;
    }
}

