/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container.registry;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.container.application.VanillaDockerApplicationImpl;
import clocker.docker.entity.container.registry.DockerRegistry;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.location.DockerHostLocation;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.feed.http.JsonFunctions;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.time.Duration;

public class DockerRegistryImpl
extends VanillaDockerApplicationImpl
implements DockerRegistry {
    private transient HttpFeed httpFeed;
    public static final String CREATE_CERTS_SCRIPT_NAME = "docker-registry-create-certs.sh";
    public static final String SCRIPT_LOCATION = "classpath://clocker/docker/entity/container/registry/docker-registry-create-certs.sh";
    public static final String DOCKER_REGISTRY_LOGO = "classpath://docker-registry-logo.png";

    private String getSSHMachineInstallDir() {
        return (String)((Entity)this.config().get(DockerRegistry.DOCKER_HOST)).sensors().get((AttributeSensor)SoftwareProcess.INSTALL_DIR);
    }

    @Override
    public String getIconUrl() {
        return DOCKER_REGISTRY_LOGO;
    }

    @Override
    public void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        HostAndPort hostAndPort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.sensors().get((AttributeSensor)DOCKER_REGISTRY_PORT)));
        this.sensors().set(Attributes.MAIN_URI, (Object)URI.create("https://" + hostAndPort + "/v2"));
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(Duration.seconds((Number)3)).baseUri((URI)this.getAttribute(Attributes.MAIN_URI)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(Attributes.SERVICE_UP).onSuccess(Functions.constant((Object)true))).onFailureOrException(Functions.constant((Object)false))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(DOCKER_REGISTRY_CATALOG).suburl("/_catalog").onSuccess(Functionals.chain((Function)HttpValueFunctions.jsonContents(), (Function)JsonFunctions.walk((String)"repositories"), (Function)JsonFunctions.forEach((Function)JsonFunctions.cast(String.class))))).onFailureOrException(Functions.constant(Collections.emptyList()))).build();
    }

    @Override
    public void disconnectSensors() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    public void init() {
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_HOST);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_REGISTRY_PORT);
        DockerHost host = (DockerHost)this.sensors().get((AttributeSensor)DOCKER_HOST);
        String installDir = (String)host.sensors().get((AttributeSensor)SoftwareProcess.INSTALL_DIR);
        SshMachineLocation sshMachine = ((DockerHostLocation)host.getDynamicLocation()).getMachine();
        String sshMachineInstallDir = this.getSSHMachineInstallDir();
        this.config().set(DockerAttributes.DOCKER_PORT_BINDINGS, (Object)MutableMap.of((Object)this.sensors().get((AttributeSensor)DOCKER_REGISTRY_PORT), (Object)5000));
        this.config().set(DockerAttributes.DOCKER_HOST_VOLUME_MAPPING, (Object)MutableMap.of((Object)Os.mergePaths((String[])new String[]{installDir, "certs"}), (Object)"/certs"));
        sshMachine.installTo((Map)ImmutableMap.of((Object)SshTool.PROP_PERMISSIONS.getName(), (Object)"0755"), SCRIPT_LOCATION, Os.mergePaths((String[])new String[]{sshMachineInstallDir, CREATE_CERTS_SCRIPT_NAME}));
        sshMachine.installTo((String)this.config().get(DockerInfrastructure.DOCKER_CA_CERTIFICATE_PATH), Os.mergePaths((String[])new String[]{sshMachineInstallDir, "ca-cert.pem"}));
        sshMachine.installTo((String)this.config().get(DockerInfrastructure.DOCKER_CA_KEY_PATH), Os.mergePaths((String[])new String[]{sshMachineInstallDir, "ca-key.pem"}));
        int result = sshMachine.execCommands("installCerts", (List)ImmutableList.of((Object)BashCommands.sudo((String)String.format("%s %s %s", Os.mergePaths((String[])new String[]{sshMachineInstallDir, CREATE_CERTS_SCRIPT_NAME}), host.sensors().get(Attributes.ADDRESS), sshMachineInstallDir))));
        if (result != 0) {
            throw new IllegalStateException("Could not create certificates for docker registry");
        }
    }
}

