/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.container.application;

import clocker.docker.entity.container.application.VanillaDockerApplication;
import clocker.docker.entity.util.DockerAttributes;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.resolve.entity.AbstractEntitySpecResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEntitySpecResolver
extends AbstractEntitySpecResolver {
    private static final Logger log = LoggerFactory.getLogger(DockerEntitySpecResolver.class);
    public static final String PREFIX = "docker";

    public DockerEntitySpecResolver() {
        super(PREFIX);
    }

    public EntitySpec<?> resolve(String type, BrooklynClassLoadingContext loader, Set<String> encounteredTypes) {
        String dockerServiceType = this.getLocalType(type);
        List parts = Splitter.on((String)":").splitToList((CharSequence)dockerServiceType);
        if (parts.isEmpty() || parts.size() > 2) {
            throw new IllegalArgumentException("Docker serviceType cannot be parsed: " + dockerServiceType);
        }
        String imageName = (String)Iterables.get((Iterable)parts, (int)0);
        String imageTag = (String)Iterables.get((Iterable)parts, (int)1, (Object)"latest");
        log.debug("Creating Docker service entity with image {} and tag {}", (Object)imageName, (Object)imageTag);
        EntitySpec spec = EntitySpec.create(VanillaDockerApplication.class);
        spec.configure(DockerAttributes.DOCKER_IMAGE_NAME, (Object)imageName);
        if (parts.size() == 2) {
            spec.configure(DockerAttributes.DOCKER_IMAGE_TAG, (Object)imageTag);
        }
        return spec;
    }
}

