/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity;

import brooklyn.networking.portforwarding.DockerPortForwarder;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.networking.subnet.SubnetTierImpl;
import clocker.docker.entity.DockerHost;
import clocker.docker.entity.DockerHostDriver;
import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.container.registry.DockerRegistry;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.entity.util.DockerUtils;
import clocker.docker.entity.util.JcloudsHostnameCustomizer;
import clocker.docker.location.DockerHostLocation;
import clocker.docker.networking.entity.sdn.DockerSdnProvider;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.util.SdnAttributes;
import clocker.docker.networking.entity.sdn.util.SdnUtils;
import clocker.docker.networking.entity.sdn.weave.WeaveNetwork;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.geo.LocalhostExternalIpLoader;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.server.BrooklynServerPaths;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.BasicGroup;
import org.apache.brooklyn.entity.machine.MachineEntityImpl;
import org.apache.brooklyn.entity.nosql.etcd.EtcdNode;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.stock.DelegateEntity;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import org.apache.brooklyn.location.jclouds.softlayer.SoftLayerSameVlanLocationCustomizer;
import org.apache.brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.policy.ha.ServiceFailureDetector;
import org.apache.brooklyn.policy.ha.ServiceReplacer;
import org.apache.brooklyn.policy.ha.ServiceRestarter;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskStub;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostImpl
extends MachineEntityImpl
implements DockerHost {
    private static final Logger LOG = LoggerFactory.getLogger(DockerHost.class);
    private transient FunctionFeed serviceUpIsRunningFeed;
    private transient FunctionFeed scan;
    private transient Object mutex = new Object[0];

    @Override
    public Object getHostMutex() {
        return this.mutex;
    }

    public void init() {
        LOG.info("Starting Docker host id {}", (Object)this.getId());
        super.init();
        String password = (String)this.config().get(DOCKER_LOGIN_PASSWORD);
        if (Strings.isBlank((CharSequence)password)) {
            password = Identifiers.makeRandomId((int)12);
            this.config().set(DOCKER_LOGIN_PASSWORD, (Object)password);
        }
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        EntitySpec dockerContainerSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)DOCKER_CONTAINER_SPEC)));
        ((EntitySpec)dockerContainerSpec.configure(DockerContainer.DOCKER_HOST, (Object)this)).configure(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this.getInfrastructure());
        if (((Boolean)this.config().get(DockerInfrastructure.HA_POLICY_ENABLE)).booleanValue()) {
            dockerContainerSpec.policy((PolicySpec)PolicySpec.create(ServiceRestarter.class).configure(ServiceRestarter.FAILURE_SENSOR_TO_MONITOR, (Object)ServiceFailureDetector.ENTITY_FAILED));
        }
        this.sensors().set((AttributeSensor)DOCKER_CONTAINER_SPEC, (Object)dockerContainerSpec);
        Group containers = (Group)this.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(BasicGroup.class).configure(BasicGroup.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).configure(BasicGroup.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).configure(BrooklynCampConstants.PLAN_ID, (Object)"docker-host-containers")).displayName("Docker Containers"));
        if (((Boolean)this.config().get(DockerInfrastructure.HA_POLICY_ENABLE)).booleanValue()) {
            containers.policies().add((PolicySpec)PolicySpec.create(ServiceReplacer.class).configure(ServiceReplacer.FAILURE_SENSOR_TO_MONITOR, (Object)ServiceRestarter.ENTITY_RESTART_FAILED));
        }
        this.sensors().set(DOCKER_CONTAINER_CLUSTER, (Object)containers);
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating((Map)ImmutableMap.of((Object)BasicGroup.GROUP_SIZE, DockerAttributes.DOCKER_CONTAINER_COUNT)).from((Entity)containers)).build());
    }

    public String getIconUrl() {
        return "classpath://docker-logo.png";
    }

    public String getDisplayName() {
        return String.format("Docker (%s)", Objects.firstNonNull((Object)this.sensors().get(Attributes.HOSTNAME), (Object)this.getId()));
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        Collection ports = super.getRequiredOpenPorts();
        if (((Boolean)this.config().get(DockerInfrastructure.SDN_ENABLE)).booleanValue()) {
            Integer weavePort;
            Entity sdn = (Entity)((Entity)this.sensors().get(DockerHost.DOCKER_INFRASTRUCTURE)).sensors().get(DockerInfrastructure.SDN_PROVIDER);
            if (SdnUtils.isSdnProvider((Entity)this.getInfrastructure(), "WeaveNetwork") && (weavePort = (Integer)sdn.config().get(WeaveNetwork.WEAVE_PORT)) != null) {
                ports.add(weavePort);
            }
        }
        return ports;
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        MutableMap flags = MutableMap.copyOf((Map)super.obtainProvisioningFlags(location));
        flags.putAll((Map)this.config().get(PROVISIONING_FLAGS));
        if (location instanceof JcloudsLocation) {
            ImmutableSet imageChoiceToRespect = ImmutableSet.of((Object)JcloudsLocationConfig.TEMPLATE_BUILDER, (Object)JcloudsLocationConfig.IMAGE_CHOOSER, (Object)JcloudsLocationConfig.IMAGE_ID, (Object)JcloudsLocationConfig.IMAGE_NAME_REGEX, (Object)JcloudsLocationConfig.IMAGE_DESCRIPTION_REGEX, (Object)JcloudsLocationConfig.OS_FAMILY, (Object[])new ConfigKey[]{JcloudsLocationConfig.OS_VERSION_REGEX, JcloudsLocationConfig.OS_64_BIT});
            ImmutableSet hardwareChoiceToRespect = ImmutableSet.of((Object)JcloudsLocationConfig.HARDWARE_ID, (Object)JcloudsLocationConfig.MIN_RAM, (Object)JcloudsLocationConfig.MIN_CORES, (Object)JcloudsLocationConfig.MIN_DISK);
            Map existingConfigOptions = ((JcloudsLocation)location).config().getBag().getAllConfig();
            TemplateBuilder template = (TemplateBuilder)flags.get(JcloudsLocationConfig.TEMPLATE_BUILDER.getName());
            boolean overrideImageChoice = true;
            for (ConfigKey key : imageChoiceToRespect) {
                if (existingConfigOptions.get(key.getName()) == null && flags.get(key.getName()) == null) continue;
                overrideImageChoice = false;
                break;
            }
            boolean overrideHardwareChoice = true;
            for (ConfigKey key : hardwareChoiceToRespect) {
                if (existingConfigOptions.get(key.getName()) == null && flags.get(key.getName()) == null) continue;
                overrideHardwareChoice = false;
                break;
            }
            if (overrideImageChoice) {
                LOG.debug("Customising image choice for {}", (Object)this);
                template = new PortableTemplateBuilder();
                if (DockerUtils.isJcloudsLocation(location, "google-compute-engine")) {
                    template.osFamily(OsFamily.CENTOS).osVersionMatches("6");
                } else if (DockerUtils.isJcloudsLocation(location, "softlayer")) {
                    template.osFamily(OsFamily.UBUNTU).osVersionMatches("14.04");
                } else {
                    template.osFamily(OsFamily.UBUNTU).osVersionMatches("15.10");
                }
                template.os64Bit(true);
                flags.put(JcloudsLocationConfig.TEMPLATE_BUILDER.getName(), template);
            } else {
                LOG.debug("Not modifying existing image configuration for {}", (Object)this);
            }
            if (overrideHardwareChoice) {
                LOG.debug("Customising hardware choice for {}", (Object)this);
                if (template != null) {
                    template.minRam(2048);
                    flags.put(JcloudsLocationConfig.TEMPLATE_BUILDER.getName(), template);
                } else {
                    flags.put(JcloudsLocationConfig.MIN_RAM.getName(), 2048);
                }
            } else {
                LOG.debug("Not modifying existing hardware configuration for {}", (Object)this);
            }
            MutableList customizers = MutableList.copyOf((Iterable)((List)flags.get(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS.getName())));
            String securityGroup = (String)this.config().get(DockerInfrastructure.SECURITY_GROUP);
            if (Strings.isNonBlank((CharSequence)securityGroup)) {
                if (DockerUtils.isJcloudsLocation(location, "google-compute-engine")) {
                    flags.put("networkName", securityGroup);
                } else {
                    flags.put("securityGroups", securityGroup);
                }
            } else {
                ConfigBag locationConfig = ((JcloudsLocation)location).getLocalConfigBag();
                if (locationConfig.containsKey(JcloudsLocation.SECURITY_GROUPS) && locationConfig.getStringKey(JcloudsLocation.SECURITY_GROUPS.getName()) instanceof String) {
                    flags.put("securityGroups", locationConfig.getStringKey(JcloudsLocation.SECURITY_GROUPS.getName()));
                } else if (DockerUtils.isJcloudsLocation(location, "google-compute-engine") && locationConfig.containsKey(JcloudsLocation.NETWORK_NAME) && locationConfig.getStringKey(JcloudsLocation.NETWORK_NAME.getName()) instanceof String) {
                    flags.put("networkName", locationConfig.getStringKey(JcloudsLocation.NETWORK_NAME.getName()));
                } else {
                    customizers.add(JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getApplicationId()));
                }
            }
            if (DockerUtils.isJcloudsLocation(location, "softlayer")) {
                if (template == null) {
                    template = new PortableTemplateBuilder();
                }
                SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
                options.portSpeed((Integer)Objects.firstNonNull((Object)options.getPortSpeed(), (Object)1000));
                template.options((TemplateOptions)options);
                flags.put(JcloudsLocationConfig.TEMPLATE_BUILDER.getName(), template);
                customizers.add(SoftLayerSameVlanLocationCustomizer.forScope((String)this.getApplicationId()));
                this.config().set(DockerInfrastructure.USE_JCLOUDS_HOSTNAME_CUSTOMIZER, (Object)true);
            }
            if (((Boolean)this.config().get(DockerInfrastructure.USE_JCLOUDS_HOSTNAME_CUSTOMIZER)).booleanValue()) {
                customizers.add(JcloudsHostnameCustomizer.instanceOf());
            }
            flags.put(JcloudsLocationConfig.JCLOUDS_LOCATION_CUSTOMIZERS.getName(), ImmutableList.copyOf((Collection)customizers));
        }
        return flags;
    }

    public String getShortName() {
        return "Docker Host";
    }

    @Override
    public Integer getCurrentSize() {
        return this.getDockerContainerCluster().getCurrentSize();
    }

    public Class<?> getDriverInterface() {
        return DockerHostDriver.class;
    }

    public DockerHostDriver getDriver() {
        return (DockerHostDriver)super.getDriver();
    }

    @Override
    public Integer getDockerPort() {
        return (Integer)this.sensors().get((AttributeSensor)DOCKER_SSL_PORT);
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return ImmutableList.copyOf((Collection)this.getDockerContainerCluster().getMembers());
    }

    @Override
    public DockerInfrastructure getInfrastructure() {
        return (DockerInfrastructure)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE);
    }

    @Override
    public String getLoginPassword() {
        return (String)this.config().get(DOCKER_LOGIN_PASSWORD);
    }

    @Override
    public String buildImage(String dockerFile, @Nullable String entrypoint, @Nullable String contextArchive, String name, boolean useSsh, Map<String, Object> substitutions) {
        String imageId = this.getDriver().buildImage(dockerFile, (Optional<String>)Optional.fromNullable((Object)entrypoint), (Optional<String>)Optional.fromNullable((Object)contextArchive), name, useSsh, substitutions);
        LOG.debug("Successfully created image {} ({})", new Object[]{imageId, name});
        return imageId;
    }

    @Override
    public String layerSshableImageOnFullyQualified(String fullyQualifiedName) {
        String imageId = this.getDriver().layerSshableImageOn(fullyQualifiedName);
        LOG.debug("Successfully added SSHable layer as {}", (Object)fullyQualifiedName);
        return imageId;
    }

    @Override
    public String layerSshableImageOn(String baseImage, String tag) {
        String imageId = this.getDriver().layerSshableImageOn(baseImage + ":" + tag);
        LOG.debug("Successfully added SSHable layer as {} from {}", (Object)imageId, (Object)baseImage);
        return imageId;
    }

    @Override
    public String runDockerCommand(String command) {
        return this.runDockerCommandTimeout(command, Duration.FIVE_MINUTES);
    }

    @Override
    public String runDockerCommandTimeout(String command, Duration timeout) {
        String stdout = this.execCommandTimeout(BashCommands.sudo((String)String.format("docker %s", command)), timeout);
        LOG.debug("Successfully executed Docker {}: {}", (Object)Strings.getFirstWord((String)command), (Object)Strings.getFirstLine((String)stdout));
        return Strings.trim((String)stdout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deployArchive(String url) {
        Tasks.setBlockingDetails((String)("Deploy " + url));
        try {
            String string = this.getDriver().deployArchive(url);
            return string;
        }
        finally {
            Tasks.resetBlockingDetails();
        }
    }

    public DockerHostLocation getDynamicLocation() {
        return (DockerHostLocation)this.sensors().get(DYNAMIC_LOCATION);
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    @Override
    public Group getDockerContainerCluster() {
        return (Group)this.sensors().get(DOCKER_CONTAINER_CLUSTER);
    }

    @Override
    public JcloudsLocation getJcloudsLocation() {
        return (JcloudsLocation)this.sensors().get(JCLOUDS_DOCKER_LOCATION);
    }

    @Override
    public SubnetTier getSubnetTier() {
        return (SubnetTier)this.sensors().get(DOCKER_HOST_SUBNET_TIER);
    }

    @Override
    public int execCommandStatus(String command) {
        return this.execCommandStatusTimeout(command, Duration.ONE_MINUTE);
    }

    @Override
    public int execCommandStatusTimeout(String command, Duration timeout) {
        ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{command}).environmentVariables(((AbstractSoftwareProcessSshDriver)this.getDriver()).getShellEnvironment())).returning(ProcessTaskStub.ScriptReturnType.EXIT_CODE).allowingNonZeroExitCode()).machine(this.getMachine())).summary(command)).newTask();
        try {
            Object result = DynamicTasks.queueIfPossible((TaskAdaptable)task).executionContext((Entity)this).orSubmitAsync().asTask().get(timeout);
            return (Integer)result;
        }
        catch (TimeoutException te) {
            throw new IllegalStateException("Timed out running command: " + command);
        }
        catch (Exception e) {
            Integer exitCode = task.getExitCode();
            LOG.warn("Command failed, return code {}: {}", (Object)(exitCode == null ? -1 : exitCode), (Object)task.getStderr());
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<String> getImageNamed(String name) {
        return this.getImageNamed(name, "latest");
    }

    @Override
    public Optional<String> getImageNamed(String name, String tag) {
        String imageList = this.runDockerCommand("images --no-trunc " + name);
        return Optional.fromNullable((Object)Strings.getFirstWordAfter((String)imageList, (String)tag));
    }

    public DockerHostLocation createLocation(Map<String, ?> flags) {
        DockerInfrastructure infrastructure = this.getInfrastructure();
        String locationName = Joiner.on((char)'-').join((Object)"docker", (Object)infrastructure.getId(), new Object[]{this.getId()});
        SshMachineLocation machine = (SshMachineLocation)Machines.findUniqueMachineLocation((Iterable)this.getLocations(), SshMachineLocation.class).get();
        DockerHostLocation location = (DockerHostLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(DockerHostLocation.class).parent(infrastructure.getDynamicLocation()).configure(flags)).configure((CharSequence)"owner", (Object)this.getProxy())).configure((CharSequence)"machine", (Object)machine)).configure((CharSequence)"locationName", (Object)locationName));
        LocationDefinition definition = location.register();
        this.sensors().set(LOCATION_SPEC, (Object)definition.getSpec());
        this.sensors().set((AttributeSensor)LOCATION_NAME, (Object)locationName);
        this.sensors().set(DYNAMIC_LOCATION, (Object)location);
        LOG.info("New Docker host location {} created for {}", (Object)location, (Object)this);
        return location;
    }

    public void deleteLocation() {
        DockerHostLocation loc = this.getDynamicLocation();
        if (loc != null) {
            loc.deregister();
            Locations.unmanage((Location)loc);
        }
        this.sensors().set(DYNAMIC_LOCATION, null);
        this.sensors().set((AttributeSensor)LOCATION_NAME, null);
    }

    @Override
    public void configureSecurityGroups() {
        Collection<IpPermission> permissions = this.getIpPermissions();
        this.addIpPermissions(permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIpPermissions(Collection<IpPermission> permissions) {
        Location location = this.getDriver().getLocation();
        String securityGroup = (String)this.config().get(DockerInfrastructure.SECURITY_GROUP);
        if (Strings.isBlank((CharSequence)securityGroup)) {
            if (!(location instanceof JcloudsSshMachineLocation)) {
                LOG.info("{} not running in a JcloudsSshMachineLocation, not removing ip permissions", (Object)this);
                return;
            }
            JcloudsMachineLocation machine = (JcloudsMachineLocation)location;
            JcloudsLocationSecurityGroupCustomizer customizer = JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getApplicationId());
            Object object = this.getInfrastructure().getInfrastructureMutex();
            synchronized (object) {
                LOG.debug("Removing permissions from security groups {}: {}", (Object)machine, permissions);
                customizer.removePermissionsFromLocation(machine, permissions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIpPermissions(Collection<IpPermission> permissions) {
        Location location = this.getDriver().getLocation();
        String securityGroup = (String)this.config().get(DockerInfrastructure.SECURITY_GROUP);
        if (Strings.isBlank((CharSequence)securityGroup)) {
            if (!(location instanceof JcloudsSshMachineLocation)) {
                LOG.info("{} not running in a JcloudsSshMachineLocation, not adding ip permissions", (Object)this);
                return;
            }
            JcloudsMachineLocation machine = (JcloudsMachineLocation)location;
            JcloudsLocationSecurityGroupCustomizer customizer = JcloudsLocationSecurityGroupCustomizer.getInstance((String)this.getApplicationId());
            Object object = this.getInfrastructure().getInfrastructureMutex();
            synchronized (object) {
                LOG.debug("Applying custom security groups to {}: {}", (Object)machine, permissions);
                customizer.addPermissionsToLocation(machine, permissions);
            }
        }
    }

    protected Collection<IpPermission> getIpPermissions() {
        MutableList permissions = MutableList.of();
        String publicIpCidr = LocalhostExternalIpLoader.getLocalhostIpWithin((Duration)Duration.minutes((Number)1)) + "/32";
        permissions.addAll(this.getClockerPermisionsForCIDR(publicIpCidr));
        if (((Boolean)this.config().get(ADD_LOCALHOST_PERMISSION)).booleanValue()) {
            String localhostAddress = Networking.getLocalHost().getHostAddress();
            String localhostCIDR = localhostAddress + "/32";
            if (Strings.isNonEmpty((CharSequence)localhostAddress) && !publicIpCidr.equals(localhostCIDR)) {
                permissions.addAll(this.getClockerPermisionsForCIDR(localhostCIDR));
            }
        }
        IpPermission dockerPortForwarding = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(32768).toPort(65534).cidrBlock(Cidr.UNIVERSAL.toString()).build();
        permissions.add(dockerPortForwarding);
        if (((Boolean)this.config().get(DockerInfrastructure.DOCKER_SHOULD_START_REGISTRY)).booleanValue() && ((Boolean)this.sensors().get(BasicGroup.FIRST_MEMBER)).booleanValue()) {
            IpPermission dockerRegistryPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.config().get(DockerRegistry.DOCKER_REGISTRY_PORT)).intValue()).toPort(((Integer)this.config().get(DockerRegistry.DOCKER_REGISTRY_PORT)).intValue()).cidrBlock(Cidr.UNIVERSAL.toString()).build();
            permissions.add(dockerRegistryPort);
        }
        return permissions;
    }

    private List<IpPermission> getClockerPermisionsForCIDR(String cidr) {
        MutableList permissions = MutableList.of();
        IpPermission dockerPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.sensors().get((AttributeSensor)DockerHost.DOCKER_PORT)).intValue()).toPort(((Integer)this.sensors().get((AttributeSensor)DockerHost.DOCKER_PORT)).intValue()).cidrBlock(cidr).build();
        permissions.add(dockerPort);
        IpPermission dockerSslPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.sensors().get((AttributeSensor)DockerHost.DOCKER_SSL_PORT)).intValue()).toPort(((Integer)this.sensors().get((AttributeSensor)DockerHost.DOCKER_SSL_PORT)).intValue()).cidrBlock(cidr).build();
        permissions.add(dockerSslPort);
        IpPermission dockerControlTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(((Integer)this.config().get(DockerHost.DOCKER_CONTROL_PLANE_PORT)).intValue()).toPort(((Integer)this.config().get(DockerHost.DOCKER_CONTROL_PLANE_PORT)).intValue()).cidrBlock(cidr).build();
        permissions.add(dockerControlTcpPort);
        IpPermission dockerControlUdpPort = IpPermission.builder().ipProtocol(IpProtocol.UDP).fromPort(((Integer)this.config().get(DockerHost.DOCKER_CONTROL_PLANE_PORT)).intValue()).toPort(((Integer)this.config().get(DockerHost.DOCKER_CONTROL_PLANE_PORT)).intValue()).cidrBlock(cidr).build();
        permissions.add(dockerControlUdpPort);
        IpPermission dockerDataUdpPort = IpPermission.builder().ipProtocol(IpProtocol.UDP).fromPort(((Integer)this.config().get(DockerHost.DOCKER_DATA_PLANE_PORT)).intValue()).toPort(((Integer)this.config().get(DockerHost.DOCKER_DATA_PLANE_PORT)).intValue()).cidrBlock(cidr).build();
        permissions.add(dockerDataUdpPort);
        PortRange etcdClientPortConfig = (PortRange)this.config().get((ConfigKey.HasConfigKey)EtcdNode.ETCD_CLIENT_PORT);
        Integer etcdClientPort = (Integer)etcdClientPortConfig.iterator().next();
        IpPermission etcdClientTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(etcdClientPort.intValue()).toPort(etcdClientPort.intValue()).cidrBlock(cidr).build();
        permissions.add(etcdClientTcpPort);
        PortRange etcdPeerPortConfig = (PortRange)this.config().get((ConfigKey.HasConfigKey)EtcdNode.ETCD_PEER_PORT);
        Integer etcdPeerPort = (Integer)etcdPeerPortConfig.iterator().next();
        IpPermission etcdPeerTcpPort = IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(etcdPeerPort.intValue()).toPort(etcdPeerPort.intValue()).cidrBlock(cidr).build();
        permissions.add(etcdPeerTcpPort);
        if (((Boolean)this.config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
            DockerSdnProvider provider = (DockerSdnProvider)((Entity)this.sensors().get(DockerHost.DOCKER_INFRASTRUCTURE)).sensors().get(DockerInfrastructure.SDN_PROVIDER);
            Collection<IpPermission> sdnPermissions = provider.getIpPermissions(cidr);
            permissions.addAll(sdnPermissions);
        }
        return permissions;
    }

    protected void preStart() {
        String keyPath;
        String certPath;
        this.configureSecurityGroups();
        Integer dockerPort = this.getDockerPort();
        boolean tlsEnabled = true;
        Maybe found = Machines.findUniqueMachineLocation((Iterable)this.getLocations(), SshMachineLocation.class);
        String dockerLocationSpec = String.format("jclouds:docker:%s://%s:%s", tlsEnabled ? "https" : "http", ((SshMachineLocation)found.get()).getSshHostAndPort().getHostText(), dockerPort);
        if (((Boolean)this.config().get(DockerInfrastructure.DOCKER_GENERATE_TLS_CERTIFICATES)).booleanValue()) {
            this.getMachine().copyTo(ResourceUtils.create().getResourceFromUrl((String)this.config().get(DockerInfrastructure.DOCKER_CA_CERTIFICATE_PATH)), "ca-cert.pem");
            this.getMachine().copyTo(ResourceUtils.create().getResourceFromUrl((String)this.config().get(DockerInfrastructure.DOCKER_CA_KEY_PATH)), "ca-key.pem");
            this.getMachine().copyTo(ResourceUtils.create().getResourceFromUrl("classpath://clocker/docker/entity/container/create-certs.sh"), "create-certs.sh");
            this.getMachine().execCommands("createCertificates", (List)ImmutableList.of((Object)"chmod 755 create-certs.sh", (Object)("./create-certs.sh " + (String)this.sensors().get(ADDRESS))));
            String localCertsDir = Os.mergePaths((String[])new String[]{BrooklynServerPaths.getMgmtBaseDir((ManagementContext)this.getManagementContext()), "docker-certs"});
            Os.mkdirs((File)new File(localCertsDir));
            certPath = Os.mergePaths((String[])new String[]{localCertsDir, this.getId() + "-cert.pem"});
            this.getMachine().copyFrom("client-cert.pem", certPath);
            keyPath = Os.mergePaths((String[])new String[]{localCertsDir, this.getId() + "-key.pem"});
            this.getMachine().copyFrom("client-key.pem", keyPath);
        } else {
            certPath = (String)this.config().get(DockerInfrastructure.DOCKER_CLIENT_CERTIFICATE_PATH);
            keyPath = (String)this.config().get(DockerInfrastructure.DOCKER_CLIENT_KEY_PATH);
        }
        JcloudsLocation jcloudsLocation = (JcloudsLocation)this.getManagementContext().getLocationRegistry().getLocationManaged(dockerLocationSpec, (Map)MutableMap.builder().put((Object)"identity", (Object)certPath).put((Object)"credential", (Object)keyPath).build());
        this.sensors().set(JCLOUDS_DOCKER_LOCATION, (Object)jcloudsLocation);
        DockerPortForwarder portForwarder = new DockerPortForwarder();
        portForwarder.setManagementContext(this.getManagementContext());
        portForwarder.init(URI.create(jcloudsLocation.getEndpoint()));
        SubnetTier subnetTier = (SubnetTier)this.addChild((EntitySpec)((EntitySpec)EntitySpec.create(SubnetTier.class, SubnetTierImpl.class).configure(SubnetTier.PORT_FORWARDER, (Object)portForwarder)).configure(SubnetTier.SUBNET_CIDR, (Object)Cidr.UNIVERSAL));
        subnetTier.start((Collection)ImmutableList.of((Object)found.get()));
        this.sensors().set(DOCKER_HOST_SUBNET_TIER, (Object)subnetTier);
        MutableMap flags = MutableMap.builder().putAll((Map)this.config().get(LOCATION_FLAGS)).put((Object)"machine", found.get()).put((Object)"jcloudsLocation", (Object)jcloudsLocation).put((Object)"portForwarder", (Object)portForwarder).build();
        this.createLocation((Map)flags);
    }

    public void postStart() {
        String imageId;
        Entities.waitForServiceUp((Entity)this);
        ((Group)this.sensors().get(DOCKER_CONTAINER_CLUSTER)).sensors().set(SERVICE_UP, (Object)Boolean.TRUE);
        if (Boolean.TRUE.equals(((Entity)this.sensors().get((AttributeSensor)DOCKER_INFRASTRUCTURE)).config().get(SdnAttributes.SDN_ENABLE))) {
            LOG.info("Waiting on SDN agent");
            SdnAgent agent = (SdnAgent)Entities.attributeSupplierWhenReady((Entity)this, SdnAgent.SDN_AGENT).get();
            Entities.waitForServiceUp((Entity)agent);
            LOG.info("SDN agent running: " + agent.sensors().get(SERVICE_UP));
        }
        if (Strings.isBlank((CharSequence)(imageId = (String)this.config().get((ConfigKey.HasConfigKey)DOCKER_IMAGE_ID)))) {
            String dockerfileUrl = (String)this.config().get(DockerInfrastructure.DOCKERFILE_URL);
            String imageName = DockerUtils.imageName((Entity)this, dockerfileUrl);
            imageId = this.buildImage(dockerfileUrl, null, null, imageName, (Boolean)this.config().get(DockerHost.DOCKER_USE_SSH), (Map<String, Object>)ImmutableMap.of((Object)"fullyQualifiedImageName", (Object)imageName));
            this.sensors().set(DOCKER_IMAGE_NAME, (Object)imageName);
        }
        this.sensors().set((AttributeSensor)DOCKER_IMAGE_ID, (Object)imageId);
        this.scan = this.scanner();
        String registryUrl = (String)this.config().get(DockerInfrastructure.DOCKER_IMAGE_REGISTRY_URL);
        Boolean internalRegistry = (Boolean)this.config().get(DockerInfrastructure.DOCKER_SHOULD_START_REGISTRY);
        if (Strings.isNonBlank((CharSequence)registryUrl) && !internalRegistry.booleanValue()) {
            String username = (String)this.config().get(DockerInfrastructure.DOCKER_IMAGE_REGISTRY_USERNAME);
            String password = (String)this.config().get(DockerInfrastructure.DOCKER_IMAGE_REGISTRY_PASSWORD);
            if (Strings.isNonBlank((CharSequence)username) && Strings.isNonBlank((CharSequence)password)) {
                this.runDockerCommand(String.format("login  -e \"fake@example.org\" -u %s -p %s %s", username, password, registryUrl));
            }
        }
    }

    private FunctionFeed scanner() {
        Duration interval = (Duration)this.config().get(SCAN_INTERVAL);
        return FunctionFeed.builder().entity((EntityLocal)this).poll((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(SCAN).period(interval)).description("Scan Containers")).callable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DockerHostImpl.this.scanContainers();
                return null;
            }
        }).onFailureOrException(Functions.constant(null))).build();
    }

    public void rebind() {
        super.rebind();
        if (this.scan == null) {
            this.scan = this.scanner();
        }
    }

    public void preStop() {
        if (this.scan != null && this.scan.isActivated()) {
            this.scan.stop();
        }
        super.preStop();
        this.deleteLocation();
        try {
            Group containers = this.getDockerContainerCluster();
            LOG.debug("Stopping containers: {}", (Object)Iterables.toString((Iterable)containers.getMembers()));
            Entities.invokeEffectorList((Entity)this, (Iterable)containers.getMembers(), (Effector)Startable.STOP).get(Duration.ONE_MINUTE);
        }
        catch (Exception e) {
            LOG.warn("Error stopping containers", (Throwable)e);
        }
        EtcdNode etcd = (EtcdNode)this.sensors().get(ETCD_NODE);
        DockerUtils.stop((Entity)this.getInfrastructure(), (Entity)etcd, Duration.THIRTY_SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanContainers() {
        this.getDynamicLocation().getLock().lock();
        try {
            String id;
            String output = this.runDockerCommand("ps");
            List ps = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).omitEmptyStrings().splitToList((CharSequence)output);
            if (ps.size() > 1) {
                for (int i = 1; i < ps.size(); ++i) {
                    String line = (String)ps.get(i);
                    id = Strings.getFirstWord((String)line);
                    Optional container = Iterables.tryFind((Iterable)this.getDockerContainerCluster().getMembers(), (Predicate)Predicates.compose((Predicate)StringPredicates.startsWith((String)id), (Function)EntityFunctions.attribute(DockerContainer.DOCKER_CONTAINER_ID)));
                    if (container.isPresent()) continue;
                    String containerId = Strings.getFirstWord((String)this.runDockerCommand("inspect --format {{.Id}} " + id));
                    String imageId = Strings.getFirstWord((String)this.runDockerCommand("inspect --format {{.Image}} " + id));
                    String imageName = Strings.getFirstWord((String)this.runDockerCommand("inspect --format {{.Config.Image}} " + id));
                    EntitySpec containerSpec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get((ConfigKey.HasConfigKey)DOCKER_CONTAINER_SPEC)));
                    ((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)containerSpec.configure(SoftwareProcess.ENTITY_STARTED, (Object)Boolean.TRUE)).configure(DockerContainer.DOCKER_HOST, (Object)this)).configure(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this.getInfrastructure())).configure(DockerContainer.DOCKER_IMAGE_ID, (Object)imageId)).configure(DockerContainer.DOCKER_IMAGE_NAME, (Object)imageName)).configure(DockerContainer.MANAGED, (Object)Boolean.FALSE)).configure(DockerContainer.LOCATION_FLAGS, (Object)MutableMap.of((Object)"container", (Object)this.getMachine()));
                    DockerContainer added = (DockerContainer)this.getDockerContainerCluster().addMemberChild(containerSpec);
                    added.sensors().set(DockerContainer.DOCKER_CONTAINER_ID, (Object)containerId);
                    added.start((Collection)ImmutableList.of((Object)this.getDynamicLocation().getMachine()));
                }
            }
            for (Entity member : ImmutableList.copyOf((Collection)this.getDockerContainerCluster().getMembers())) {
                Lifecycle state;
                Optional found;
                id = (String)member.sensors().get(DockerContainer.DOCKER_CONTAINER_ID);
                if (id != null && (found = Iterables.tryFind((Iterable)ps, (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        String firstWord = Strings.getFirstWord((String)input);
                        return id.startsWith(firstWord);
                    }
                })).isPresent() || Lifecycle.ON_FIRE.equals((Object)(state = (Lifecycle)member.sensors().get(SERVICE_STATE_ACTUAL))) || Lifecycle.STARTING.equals((Object)state)) continue;
                if (Lifecycle.STOPPING.equals((Object)state) || Lifecycle.STOPPED.equals((Object)state)) {
                    this.getDockerContainerCluster().removeMember(member);
                    this.getDockerContainerCluster().removeChild(member);
                    Entities.unmanage((Entity)member);
                    continue;
                }
                ServiceStateLogic.setExpectedState((Entity)member, (Lifecycle)Lifecycle.STOPPING);
            }
        }
        finally {
            this.getDynamicLocation().getLock().unlock();
        }
    }

    protected void connectServiceUpIsRunning() {
        this.serviceUpIsRunningFeed = FunctionFeed.builder().entity((EntityLocal)this).period(Duration.THIRTY_SECONDS).poll(((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(SERVICE_PROCESS_IS_RUNNING).suppressDuplicates(true)).onException(Functions.constant((Object)Boolean.FALSE))).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return DockerHostImpl.this.getDriver().isRunning();
            }
        })).build();
    }

    protected void disconnectServiceUpIsRunning() {
        if (this.serviceUpIsRunningFeed != null) {
            this.serviceUpIsRunningFeed.stop();
        }
    }

    static {
        RendererHints.register((AttributeSensor)DOCKER_INFRASTRUCTURE, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)DOCKER_CONTAINER_CLUSTER, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)ETCD_NODE, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
    }
}

