/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.test;

import clocker.docker.location.DockerLocation;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.core.test.entity.TestEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementedBy(value=LiveTestEntityImpl.class)
public interface LiveTestEntity
extends TestEntity {
    public MachineProvisioningLocation getProvisioningLocation();

    public MachineLocation getObtainedLocation();

    public static class LiveTestEntityImpl
    extends TestEntityImpl
    implements LiveTestEntity {
        private static final Logger LOG = LoggerFactory.getLogger(LiveTestEntity.class);
        private DockerLocation provisioningLocation;
        private MachineLocation obtainedLocation;

        public void start(Collection<? extends Location> locs) {
            LOG.trace("Starting {}", (Object)this);
            this.callHistory.add("start");
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
            this.counter.incrementAndGet();
            this.addLocations(locs);
            this.provisioningLocation = (DockerLocation)Iterables.find(locs, (Predicate)Predicates.instanceOf(DockerLocation.class));
            try {
                this.obtainedLocation = this.provisioningLocation.obtain(this.provisioningLocation.getAllConfig(true));
            }
            catch (NoMachinesAvailableException e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.addLocations((Collection)ImmutableList.of((Object)this.obtainedLocation));
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        }

        public void stop() {
            LOG.trace("Stopping {}", (Object)this);
            this.callHistory.add("stop");
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
            this.counter.decrementAndGet();
            if (this.provisioningLocation != null && this.obtainedLocation != null) {
                this.provisioningLocation.release(this.obtainedLocation);
            }
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
        }

        @Override
        public MachineProvisioningLocation getProvisioningLocation() {
            return this.provisioningLocation;
        }

        @Override
        public MachineLocation getObtainedLocation() {
            return this.obtainedLocation;
        }
    }
}

