/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.test;

import clocker.docker.entity.DockerInfrastructure;
import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.test.AbstractClockerIntegrationTest;
import clocker.docker.test.DockerInfrastructureTests;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityAsserts;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.proxy.haproxy.HAProxyController;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.webapp.JavaWebAppService;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.entity.webapp.tomcat.TomcatServer;
import org.apache.brooklyn.test.support.TestResourceUnavailableException;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.testng.annotations.Test;

public class DockerHAProxyIntegrationTest
extends AbstractClockerIntegrationTest {
    private EntitySpec<HAProxyController> haProxySpec() {
        return (EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(HAProxyController.class).configure((ConfigKey.HasConfigKey)DockerAttributes.DOCKER_IMAGE_NAME, (Object)"haproxy")).configure((ConfigKey.HasConfigKey)DockerAttributes.DOCKER_IMAGE_TAG, (Object)"latest")).configure((ConfigKey.HasConfigKey)SoftwareProcess.INSTALL_DIR, (Object)"/usr/local/sbin/")).configure((ConfigKey.HasConfigKey)SoftwareProcess.RUN_DIR, (Object)"/usr/local/etc/haproxy/");
    }

    private EntitySpec<TomcatServer> tomcatSpec() {
        return EntitySpec.create(TomcatServer.class);
    }

    private String getTestWar() {
        TestResourceUnavailableException.throwIfResourceUnavailable(((Object)((Object)this)).getClass(), (String)"/hello-world.war");
        return "classpath://hello-world.war";
    }

    private AttributeSensor<String> mappedSensor(Sensor<String> sensor) {
        return Sensors.newStringSensor((String)("mapped." + sensor.getName()));
    }

    @Test(groups={"Integration"})
    public void testContainerFromImageName() {
        DockerInfrastructure infrastructure = DockerInfrastructureTests.deployAndWaitForDockerInfrastructure(this.app, this.testLocation);
        TestApplication testApp = (TestApplication)this.app.getManagementContext().getEntityManager().createEntity(EntitySpec.create(TestApplication.class));
        DynamicCluster serverPool = (DynamicCluster)testApp.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(DynamicCluster.class).configure(DynamicCluster.MEMBER_SPEC, this.tomcatSpec())).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)1)).configure(JavaWebAppService.ROOT_WAR, (Object)this.getTestWar()));
        HAProxyController hap = (HAProxyController)testApp.createAndManageChild((EntitySpec)((EntitySpec)this.haProxySpec().configure(HAProxyController.SERVER_POOL, (Object)serverPool)).configure((ConfigKey.HasConfigKey)HAProxyController.HOSTNAME_SENSOR, (Object)Attributes.SUBNET_HOSTNAME));
        testApp.start((Collection)ImmutableList.of((Object)infrastructure.getDynamicLocation()));
        EntityAsserts.assertAttributeEqualsEventually((Entity)hap, (AttributeSensor)Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.RUNNING);
        HttpAsserts.assertHttpStatusCodeEventuallyEquals((String)((String)hap.sensors().get(this.mappedSensor((Sensor<String>)HAProxyController.ROOT_URL))), (int)200);
        for (Entity member : serverPool.getMembers()) {
            HttpAsserts.assertHttpStatusCodeEventuallyEquals((String)((String)member.sensors().get(this.mappedSensor((Sensor<String>)WebAppService.ROOT_URL))), (int)200);
        }
        testApp.stop();
    }
}

