/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking;

import java.net.InetAddress;
import org.apache.brooklyn.util.net.Cidr;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CidrTest {
    @Test
    public void testCidr() {
        Cidr pool = Cidr.LINK_LOCAL;
        int size = 27;
        int allocated = 8;
        Cidr subnet = this.getSubnet(pool, size, allocated);
        System.out.println("Subnet " + subnet);
        Assert.assertEquals((Object)subnet, (Object)new Cidr("169.254.1.0/27"));
    }

    public Cidr getSubnet(Cidr pool, int size, int allocated) {
        int offset = allocated * (1 << 32 - size);
        InetAddress base = pool.addressAtOffset(offset);
        Cidr subnet = new Cidr(base.getHostAddress() + "/" + size);
        return subnet;
    }
}

