/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn;

import clocker.docker.entity.DockerHost;
import clocker.docker.networking.entity.VirtualNetwork;
import clocker.docker.networking.entity.sdn.DockerSdnProvider;
import clocker.docker.networking.entity.sdn.SdnAgent;
import clocker.docker.networking.entity.sdn.SdnAgentDriver;
import clocker.docker.networking.entity.sdn.SdnProvider;
import clocker.docker.networking.entity.sdn.util.SdnUtils;
import com.google.common.base.Function;
import java.net.InetAddress;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.stock.DelegateEntity;
import org.apache.brooklyn.util.net.Cidr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdnAgentImpl
extends SoftwareProcessImpl
implements SdnAgent {
    private static final Logger LOG = LoggerFactory.getLogger(SdnAgent.class);

    public void init() {
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_HOST);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)SDN_PROVIDER);
    }

    public SdnAgentDriver getDriver() {
        return (SdnAgentDriver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        super.connectServiceUpIsRunning();
    }

    public void disconnectSensors() {
        super.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    @Override
    public DockerHost getDockerHost() {
        return (DockerHost)this.sensors().get((AttributeSensor)DOCKER_HOST);
    }

    public void preStart() {
        InetAddress address = ((DockerSdnProvider)this.sensors().get((AttributeSensor)SDN_PROVIDER)).getNextAgentAddress(this.getId());
        this.sensors().set(SDN_AGENT_ADDRESS, (Object)address);
    }

    public void postStart() {
        this.getDockerHost().sensors().set(SDN_AGENT, (Object)this);
    }

    public void rebind() {
        super.rebind();
    }

    @Override
    public VirtualNetwork createNetwork(String networkId) {
        SdnProvider provider = (SdnProvider)this.sensors().get((AttributeSensor)SDN_PROVIDER);
        VirtualNetwork network = SdnUtils.createNetwork(provider, networkId);
        return network;
    }

    @Override
    public InetAddress attachNetwork(String containerId, String networkId) {
        InetAddress address = this.getDriver().attachNetwork(containerId, networkId);
        LOG.info("Attached container ID {} to {}: {}", new Object[]{containerId, networkId, address.getHostAddress()});
        return address;
    }

    @Override
    public String provisionNetwork(VirtualNetwork network) {
        String networkId = (String)network.sensors().get(VirtualNetwork.NETWORK_ID);
        SdnProvider provider = (SdnProvider)this.sensors().get((AttributeSensor)SDN_PROVIDER);
        Cidr subnetCidr = SdnUtils.provisionNetwork(provider, network);
        this.getDriver().createSubnet(networkId, subnetCidr);
        return networkId;
    }

    @Override
    public void deallocateNetwork(VirtualNetwork network) {
        String networkId = (String)network.sensors().get(VirtualNetwork.NETWORK_ID);
        this.getDriver().deleteSubnet(networkId);
    }

    static {
        RendererHints.register((AttributeSensor)DOCKER_HOST, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_PROVIDER, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_AGENT, (RendererHints.Hint)RendererHints.openWithUrl((Function)DelegateEntity.EntityUrl.entityUrl()));
    }
}

