/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.networking.entity.sdn;

import clocker.docker.entity.util.DockerAttributes;
import clocker.docker.networking.entity.sdn.SdnProvider;
import clocker.docker.networking.entity.sdn.SdnProviderImpl;
import com.google.common.reflect.TypeToken;
import com.google.inject.ImplementedBy;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.net.Cidr;
import org.jclouds.net.domain.IpPermission;

@ImplementedBy(value=SdnProviderImpl.class)
public interface DockerSdnProvider
extends SdnProvider {
    public static final ConfigKey<Cidr> AGENT_CIDR = ConfigKeys.newConfigKey(Cidr.class, (String)"sdn.agent.cidr", (String)"CIDR for agent address allocation");
    public static final AttributeSensor<Group> SDN_AGENTS = Sensors.newSensor(Group.class, (String)"sdn.agents", (String)"Group of SDN agent services");
    public static final AttributeSensor<Integer> ALLOCATED_IPS = Sensors.newIntegerSensor((String)"sdn.agent.ips", (String)"Number of allocated IPs for agents");
    public static final AttributeSensor<Map<String, InetAddress>> ALLOCATED_ADDRESSES = Sensors.newSensor((TypeToken)new TypeToken<Map<String, InetAddress>>(){}, (String)"sdn.agent.addresses", (String)"Allocated IP addresses for agents");
    @SetFromFlag(value="agentSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec<?>, EntitySpec<?>> SDN_AGENT_SPEC = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<EntitySpec<?>>(){}, (String)"sdn.agent.spec", (String)"SDN agent specification");
    @SetFromFlag(value="dockerInfrastructure")
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_INFRASTRUCTURE = DockerAttributes.DOCKER_INFRASTRUCTURE;

    public Collection<IpPermission> getIpPermissions(String var1);

    public DynamicCluster getDockerHostCluster();

    public Group getAgents();

    public InetAddress getNextAgentAddress(String var1);
}

