/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location.strategy.util;

import clocker.docker.entity.container.DockerContainer;
import clocker.docker.location.DockerHostLocation;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class StrategyPredicates {
    private static final Logger LOG = LoggerFactory.getLogger(StrategyPredicates.class);

    private StrategyPredicates() {
    }

    public static Predicate<DockerHostLocation> childrenOf(Entity parent) {
        return new ChildrenOfPredicate(parent);
    }

    public static Predicate<DockerHostLocation> hasApplicationId(String applicationId) {
        return new HasApplicationIdPredicate(applicationId);
    }

    public static Predicate<DockerHostLocation> nonEmpty() {
        return new NonEmptyPredicate();
    }

    public static class NonEmptyPredicate
    implements Predicate<DockerHostLocation> {
        public boolean apply(DockerHostLocation input) {
            Iterable deployed = Iterables.filter((Iterable)Iterables.transform(input.getDockerContainerList(), (Function)EntityFunctions.config((ConfigKey)DockerContainer.ENTITY.getConfigKey())), (Predicate)Predicates.notNull());
            return Iterables.size((Iterable)deployed) > 0;
        }
    }

    public static class HasApplicationIdPredicate
    implements Predicate<DockerHostLocation> {
        private String applicationId;

        public HasApplicationIdPredicate(String applicationId) {
            this.applicationId = applicationId;
        }

        public boolean apply(DockerHostLocation input) {
            Iterable deployed = Iterables.filter((Iterable)Iterables.transform(input.getDockerContainerList(), (Function)EntityFunctions.config((ConfigKey)DockerContainer.ENTITY.getConfigKey())), (Predicate)Predicates.notNull());
            Iterable sameApplication = Iterables.filter((Iterable)deployed, (Predicate)EntityPredicates.applicationIdEqualTo((String)this.applicationId));
            if (Iterables.isEmpty((Iterable)sameApplication)) {
                LOG.debug("No entities with application id {} on {}", (Object)this.applicationId, (Object)input);
                return false;
            }
            LOG.debug("Found entities with application id {} on {}", (Object)this.applicationId, (Object)input);
            return true;
        }
    }

    public static class ChildrenOfPredicate
    implements Predicate<DockerHostLocation> {
        private Entity parent;

        public ChildrenOfPredicate(Entity parent) {
            this.parent = parent;
        }

        public boolean apply(DockerHostLocation input) {
            Iterable deployed = Iterables.filter((Iterable)Iterables.transform(input.getDockerContainerList(), (Function)EntityFunctions.config((ConfigKey)DockerContainer.ENTITY.getConfigKey())), (Predicate)Predicates.notNull());
            Iterable sameParent = Iterables.filter((Iterable)deployed, (Predicate)EntityPredicates.isChildOf((Entity)this.parent));
            if (Iterables.isEmpty((Iterable)sameParent)) {
                LOG.debug("No entities with parent {} on {}", (Object)this.parent, (Object)input);
                return false;
            }
            LOG.debug("Found entities with parent {} on {}", (Object)this.parent, (Object)input);
            return true;
        }
    }
}

