/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location.strategy.basic;

import clocker.docker.location.DockerHostLocation;
import clocker.docker.location.strategy.AbstractDockerPlacementStrategy;
import clocker.docker.location.strategy.util.StrategyPredicates;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Monitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@ThreadSafe
public class GroupPlacementStrategy
extends AbstractDockerPlacementStrategy
implements WithMutexes {
    private static final Logger LOG = LoggerFactory.getLogger(GroupPlacementStrategy.class);
    private static final Object LOCK = new Object[0];
    @SetFromFlag(value="exclusive")
    public static final ConfigKey<Boolean> REQUIRE_EXCLUSIVE = ConfigKeys.newBooleanConfigKey((String)"docker.constraint.exclusive", (String)"Whether the Docker host must be exclusive to this application; by default other applications can co-exist", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="timeout")
    public static final ConfigKey<Duration> STRATEGY_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"docker.strategy.timeout", (String)"How long to wait for other entities using the strategy", (Duration)Duration.minutes((Number)20));
    public static final ConfigKey<Map<String, Monitor>> MONITOR_MAP = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, Monitor>>(){}, (String)"groupPlacementStrategy.map.monitors", (String)"A mapping from application IDs to monitors; used to synchronize threads during strategy execution.");

    @Override
    public List<DockerHostLocation> filterLocations(List<DockerHostLocation> locations, Entity entity) {
        if (locations == null || locations.isEmpty()) {
            return ImmutableList.of();
        }
        if (this.getDockerInfrastructure() == null) {
            this.config().set(DOCKER_INFRASTRUCTURE, (Object)((DockerHostLocation)Iterables.getLast(locations)).getDockerInfrastructure());
        }
        MutableList available = MutableList.copyOf(locations);
        boolean requireExclusive = (Boolean)this.config().get(REQUIRE_EXCLUSIVE);
        try {
            this.acquireMutex(entity.getApplicationId(), "Filtering locations for " + entity);
        }
        catch (InterruptedException ie) {
            Exceptions.propagate((Throwable)ie);
        }
        Iterable sameApplication = Iterables.filter((Iterable)available, StrategyPredicates.hasApplicationId(entity.getApplicationId()));
        Optional sameParent = Iterables.tryFind((Iterable)sameApplication, StrategyPredicates.childrenOf(entity.getParent()));
        if (sameParent.isPresent()) {
            LOG.debug("Returning {} (same parent) for {} placement", sameParent.get(), (Object)entity);
            return ImmutableList.copyOf((Collection)sameParent.asSet());
        }
        Iterables.removeIf((Iterable)available, StrategyPredicates.hasApplicationId(entity.getApplicationId()));
        if (requireExclusive) {
            Iterables.removeIf((Iterable)available, StrategyPredicates.nonEmpty());
        }
        LOG.debug("Returning {} for {} placement", (Object)Iterables.toString((Iterable)available), (Object)entity);
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Monitor lookupMonitor(String mutexId) {
        Object object = LOCK;
        synchronized (object) {
            Map map = (Map)this.getDockerInfrastructure().config().get(MONITOR_MAP);
            return map != null ? (Monitor)map.get(mutexId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Monitor createMonitor(String mutexId) {
        Object object = LOCK;
        synchronized (object) {
            Map map = (Map)this.getDockerInfrastructure().config().get(MONITOR_MAP);
            if (map == null) {
                map = MutableMap.of();
            }
            if (!map.containsKey(mutexId)) {
                map.put(mutexId, new Monitor());
                this.getDockerInfrastructure().config().set(MONITOR_MAP, (Object)map);
            }
            Monitor monitor = (Monitor)map.get(mutexId);
            return monitor;
        }
    }

    public boolean hasMutex(String mutexId) {
        throw new UnsupportedOperationException();
    }

    public void acquireMutex(String mutexId, String description) throws InterruptedException {
        LOG.debug("Enter monitor {}: {}", (Object)mutexId, (Object)description);
        Monitor monitor = this.createMonitor(mutexId);
        Duration timeout = (Duration)this.config().get(STRATEGY_TIMEOUT);
        monitor.enter(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public boolean tryAcquireMutex(String mutexId, String description) {
        LOG.debug("Try to enter monitor {}: {}", (Object)mutexId, (Object)description);
        Monitor monitor = this.createMonitor(mutexId);
        return monitor.tryEnter();
    }

    public void releaseMutex(String mutexId) {
        LOG.debug("Leaving monitor {}", (Object)mutexId);
        Monitor monitor = this.lookupMonitor(mutexId);
        if (monitor != null && monitor.isOccupiedByCurrentThread()) {
            monitor.leave();
        }
    }
}

