/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.location;

import clocker.docker.location.DockerHostLocation;
import clocker.docker.location.DockerLocation;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.objs.proxy.SpecialBrooklynObjectConstructor;
import org.apache.brooklyn.util.text.KeyValueParser;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerResolver
implements LocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DockerResolver.class);
    public static final String DOCKER = "docker";
    public static final Pattern PATTERN = Pattern.compile("(docker|" + "docker".toUpperCase() + ")" + ":([a-zA-Z0-9]+)" + "(:([a-zA-Z0-9]+))?" + "(:\\((.*)\\))?$");
    public static final Set<String> ACCEPTABLE_ARGS = ImmutableSet.of((Object)"name");
    public static final String DOCKER_INFRASTRUCTURE_SPEC = "docker:%s";
    public static final String DOCKER_HOST_MACHINE_SPEC = "docker:%s:%s";
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public String getPrefix() {
        return DOCKER;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec((LocationResolver)this, (String)spec, (boolean)true);
    }

    public boolean isEnabled() {
        return true;
    }

    public LocationSpec<? extends Location> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        Matcher matcher;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving location '" + spec + "' with flags " + Joiner.on((String)",").withKeyValueSeparator("=").join(locationFlags));
        }
        if (!(matcher = PATTERN.matcher(spec)).matches()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; must specify something like docker:locId or docker:locId:(name=abc)");
        }
        String infrastructureLocId = matcher.group(2);
        if (Strings.isBlank((CharSequence)infrastructureLocId)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; infrastructure location id must be non-empty");
        }
        String hostLocId = matcher.group(4);
        String argsPart = matcher.group(6);
        Map argsMap = argsPart != null ? KeyValueParser.parseMap((String)argsPart) : Collections.emptyMap();
        String namePart = (String)argsMap.get("name");
        if (!ACCEPTABLE_ARGS.containsAll(argsMap.keySet())) {
            Sets.SetView illegalArgs = Sets.difference(argsMap.keySet(), ACCEPTABLE_ARGS);
            throw new IllegalArgumentException("Invalid location '" + spec + "'; illegal args " + illegalArgs + "; acceptable args are " + ACCEPTABLE_ARGS);
        }
        if (argsMap.containsKey("name") && Strings.isEmpty((CharSequence)namePart)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; if name supplied then value must be non-empty");
        }
        Location infrastructureLoc = this.managementContext.getLocationManager().getLocation(infrastructureLocId);
        if (infrastructureLoc == null) {
            throw new IllegalArgumentException("Unknown Clocker infrastructure location id " + infrastructureLocId + ", spec " + spec);
        }
        if (!(infrastructureLoc instanceof DockerLocation)) {
            throw new IllegalArgumentException("Invalid location id for Clocker infrastructure, spec " + spec + "; instead matches " + infrastructureLoc);
        }
        if (hostLocId != null) {
            Location hostLoc = this.managementContext.getLocationManager().getLocation(hostLocId);
            if (hostLoc == null) {
                throw new IllegalArgumentException("Unknown Clocker host location id " + hostLocId + ", spec " + spec);
            }
            if (!(hostLoc instanceof DockerHostLocation)) {
                throw new IllegalArgumentException("Invalid location id for Clocker host, spec " + spec + "; instead matches " + hostLoc);
            }
            return (LocationSpec)((LocationSpec)LocationSpec.create(DockerHostLocation.class).configure(LocationConstructor.LOCATION, (Object)hostLoc)).configure(SpecialBrooklynObjectConstructor.Config.SPECIAL_CONSTRUCTOR, LocationConstructor.class);
        }
        return (LocationSpec)((LocationSpec)LocationSpec.create(DockerLocation.class).configure(LocationConstructor.LOCATION, (Object)infrastructureLoc)).configure(SpecialBrooklynObjectConstructor.Config.SPECIAL_CONSTRUCTOR, LocationConstructor.class);
    }

    @Beta
    public static class LocationConstructor
    implements SpecialBrooklynObjectConstructor {
        public static ConfigKey<Location> LOCATION = ConfigKeys.newConfigKey(Location.class, (String)"resolver.location");

        public <T> T create(ManagementContext mgmt, Class<T> type, AbstractBrooklynObjectSpec<?, ?> spec) {
            return (T)Preconditions.checkNotNull(spec.getConfig().get(LOCATION), (Object)LOCATION.getName());
        }
    }
}

