/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.util;

import clocker.docker.location.strategy.DockerAwarePlacementStrategy;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.javalang.Reflections;

public class DockerAttributes {
    public static final ConfigKey<String> DOCKERFILE_URL = ConfigKeys.newStringConfigKey((String)"docker.dockerfile.url", (String)"URL of a Dockerfile to use");
    public static final ConfigKey<String> DOCKERFILE_ENTRYPOINT_URL = ConfigKeys.newStringConfigKey((String)"docker.entrypoint.url", (String)"URL of the Dockerfile entrypoint script to use. (default is no script)");
    public static final ConfigKey<String> DOCKERFILE_CONTEXT_URL = ConfigKeys.newStringConfigKey((String)"docker.context.url", (String)"URL of the Dockerfile context archive to use. (default is no context)");
    public static final ConfigKey<String> DOCKERFILE_NAME = ConfigKeys.newStringConfigKey((String)"docker.dockerfile.name", (String)"Name for the image created by the Dockerfile being used");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_ID = ConfigKeys.newStringSensorAndConfigKey((String)"docker.image.id", (String)"The ID of a Docker image to use for a container");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_REGISTRY_URL = ConfigKeys.newStringSensorAndConfigKey((String)"docker.registry.url", (String)"The URL of the Docker image registry");
    public static final AttributeSensor<Entity> DOCKER_IMAGE_REGISTRY = Sensors.newSensor(Entity.class, (String)"docker.registry.entity", (String)"The Docker image registry entity");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"docker.image.name", (String)"The name of the Docker image used by a container");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_IMAGE_TAG = ConfigKeys.newStringSensorAndConfigKey((String)"docker.image.tag", (String)"The tag of the image to use", (String)"latest");
    public static final AttributeSensorAndConfigKey<List<String>, List<String>> DOCKER_IMAGE_ENTRYPOINT = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"docker.image.entrypoint", (String)"Optional replacement for the image entrypoint command and arguments");
    public static final AttributeSensorAndConfigKey<List<String>, List<String>> DOCKER_IMAGE_COMMANDS = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"docker.image.commands", (String)"Optional replacement for the image commands");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_HARDWARE_ID = ConfigKeys.newStringSensorAndConfigKey((String)"docker.hardwareId", (String)"The ID of a Docker hardware type to use for a container", (String)"small");
    public static final AttributeSensorAndConfigKey<String, String> DOCKER_CONTAINER_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"docker.container.name", (String)"The name of the Docker container");
    public static final ConfigKey<String> DOCKER_LOGIN_USER = ConfigKeys.newConfigKeyWithDefault((ConfigKey)ConfigKeys.newConfigKeyWithPrefix((String)"docker.", (ConfigKey)JcloudsLocationConfig.LOGIN_USER), (Object)"root");
    public static final ConfigKey<String> DOCKER_LOGIN_PASSWORD = ConfigKeys.newConfigKeyWithPrefix((String)"docker.", (ConfigKey)JcloudsLocationConfig.LOGIN_USER_PASSWORD);
    public static final ConfigKey<Boolean> DOCKER_USE_HOST_DNS_NAME = ConfigKeys.newBooleanConfigKey((String)"docker.useHostDnsName", (String)"Container uses same DNS hostname as Docker host");
    public static final ConfigKey<Boolean> DOCKER_USE_SSH = ConfigKeys.newBooleanConfigKey((String)"docker.useSsh", (String)"Use SSH layer instead of docker exec for container commands", (Boolean)Boolean.TRUE);
    public static final AttributeSensor<String> DOCKER_MAPPED_SSH_PORT = Sensors.newStringSensor((String)"mapped.docker.port.22", (String)"Docker mapping for SSH default port");
    public static final ConfigKey<Integer> DOCKER_CPU_SHARES = ConfigKeys.newIntegerConfigKey((String)"docker.cpuShares", (String)"Container CPU shares configuration");
    public static final ConfigKey<Integer> DOCKER_MEMORY = ConfigKeys.newIntegerConfigKey((String)"docker.memory", (String)"Container memory configuration");
    public static final ConfigKey<Boolean> PRIVILEGED = ConfigKeys.newBooleanConfigKey((String)"docker.container.privileged", (String)"Set to true if the container is to be privileged", (Boolean)Boolean.TRUE);
    public static final ConfigKey<Boolean> INTERACTIVE = ConfigKeys.newBooleanConfigKey((String)"docker.container.interactive", (String)"Set to true if STDIN is to be kept open for an interactive container", (Boolean)Boolean.FALSE);
    public static final ConfigKey<Boolean> MANAGED = ConfigKeys.newBooleanConfigKey((String)"docker.container.managed", (String)"Set to false if the container is not managed by Brooklyn and Clocker", (Boolean)Boolean.TRUE);
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"docker.host.volumes", (String)"Host volume mapping configuration");
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUME_EXPORT = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"docker.container.volumes.export", (String)"Container volume export configuration");
    public static final ConfigKey<List<String>> DOCKER_CONTAINER_VOLUMES_FROM = ConfigKeys.builder((TypeToken)new TypeToken<List<String>>(){}).name("docker.container.volumes.import").description("Container volume import configuration").defaultValue((Object)ImmutableList.of()).inheritance(ConfigInheritance.NONE).build();
    public static final AttributeSensor<Map<String, String>> DOCKER_VOLUME_MAPPING = Sensors.newSensor((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"docker.container.volumes", (String)"Container volume mappings");
    public static final ConfigKey<List<DockerAwarePlacementStrategy>> PLACEMENT_STRATEGIES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<DockerAwarePlacementStrategy>>(){}, (String)"docker.container.strategies", (String)"Placement strategy list for Docker containers");
    public static final AttributeSensorAndConfigKey<Entity, Entity> DOCKER_INFRASTRUCTURE = ConfigKeys.newSensorAndConfigKey(Entity.class, (String)"docker.infrastructure", (String)"The Docker infrastructure");
    public static final ConfigKey<Boolean> AUTO_CHECKPOINT_DOCKER_IMAGE_POST_INSTALL = ConfigKeys.newBooleanConfigKey((String)"docker.container.autoCheckpointImage", (String)"Whether to automatically create an image after the entity's install(), and subsequently re-use that image for the entity type", (Boolean)false);
    public static final ConfigKey<Map<String, Entity>> DOCKER_LINKS = ConfigKeys.builder((TypeToken)new TypeToken<Map<String, Entity>>(){}).name("docker.container.links").description("List of linked entities for a container").defaultValue((Object)ImmutableMap.of()).inheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<List<PortAttributeSensorAndConfigKey>> DOCKER_DIRECT_PORT_CONFIG = ConfigKeys.builder((TypeToken)new TypeToken<List<PortAttributeSensorAndConfigKey>>(){}).name("docker.container.directPorts.configKeys").description("List of configration keys for ports that are to be mapped directly on the Docker host").defaultValue((Object)ImmutableList.of()).inheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<List<Integer>> DOCKER_DIRECT_PORTS = ConfigKeys.builder((TypeToken)new TypeToken<List<Integer>>(){}).name("docker.container.directPorts").description("List of ports that are to be mapped directly on the Docker host").defaultValue((Object)ImmutableList.of()).inheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<List<Integer>> DOCKER_OPEN_PORTS = ConfigKeys.builder((TypeToken)new TypeToken<List<Integer>>(){}).name("docker.container.openPorts").description("List of ports to open on the container for forwarding").defaultValue((Object)ImmutableList.of()).inheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<List<PortAttributeSensorAndConfigKey>> DOCKER_OPEN_PORT_CONFIG = ConfigKeys.builder((TypeToken)new TypeToken<List<PortAttributeSensorAndConfigKey>>(){}).name("docker.container.openPorts.configKeys").description("List of configration keys for ports to open on the container for forwarding").defaultValue((Object)ImmutableList.of()).inheritance(ConfigInheritance.NONE).build();
    public static final ConfigKey<Map<Integer, Integer>> DOCKER_PORT_BINDINGS = ConfigKeys.builder((TypeToken)new TypeToken<Map<Integer, Integer>>(){}).name("docker.container.portBindings").description("Map of port bindings from the host to the container").defaultValue((Object)ImmutableMap.of()).inheritance(ConfigInheritance.NONE).build();
    public static final AttributeSensor<Map<Integer, Integer>> DOCKER_CONTAINER_PORT_BINDINGS = Sensors.newSensor((TypeToken)new TypeToken<Map<Integer, Integer>>(){}, (String)"docker.container.portBindings", (String)"Map of port bindings from the host to the container");
    public static final AttributeSensor<List<Integer>> DOCKER_CONTAINER_OPEN_PORTS = Sensors.newSensor((TypeToken)new TypeToken<List<Integer>>(){}, (String)"docker.container.openPorts", (String)"List of ports to open on the container for forwarding");
    public static final AttributeSensor<Integer> DOCKER_HOST_COUNT = Sensors.newIntegerSensor((String)"docker.hosts.total", (String)"Number of Docker hosts");
    public static final AttributeSensor<Integer> DOCKER_CONTAINER_COUNT = Sensors.newIntegerSensor((String)"docker.containers.total", (String)"Number of Docker containers");
    public static final AttributeSensor<Integer> DOCKER_IDLE_HOST_COUNT = Sensors.newIntegerSensor((String)"docker.hosts.idle", (String)"Number of idle Docker hosts");
    public static final AttributeSensor<Integer> DOCKER_IDLE_CONTAINER_COUNT = Sensors.newIntegerSensor((String)"docker.containers.idle", (String)"Number of idle Docker containers");
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    private DockerAttributes() {
    }

    public static void init() {
        if (initialized.getAndSet(true)) {
            return;
        }
        TypeCoercions.registerAdapter(String.class, DockerAwarePlacementStrategy.class, (Function)new Function<String, DockerAwarePlacementStrategy>(){

            public DockerAwarePlacementStrategy apply(String input) {
                ClassLoader classLoader = DockerAwarePlacementStrategy.class.getClassLoader();
                Optional strategy = Reflections.invokeConstructorWithArgs((ClassLoader)classLoader, (String)input, (Object[])new Object[0]);
                if (strategy.isPresent()) {
                    return (DockerAwarePlacementStrategy)strategy.get();
                }
                throw new IllegalStateException("Failed to create DockerAwarePlacementStrategy " + input);
            }
        });
    }

    static {
        DockerAttributes.init();
    }
}

