/*
 * Decompiled with CFR 0.152.
 */
package clocker.docker.entity.microservice;

import clocker.docker.entity.DockerHost;
import clocker.docker.entity.container.DockerContainer;
import clocker.docker.entity.microservice.MicroserviceImageImpl;
import clocker.docker.entity.util.DockerAttributes;
import java.util.Map;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=MicroserviceImageImpl.class)
public interface Microservice
extends StartableApplication {
    public static final String DOCKER_LOCATION_PREFIX = "docker-";
    @CatalogConfig(label="Container Name", priority=90.0)
    @SetFromFlag(value="containerName")
    public static final ConfigKey<String> CONTAINER_NAME = DockerContainer.DOCKER_CONTAINER_NAME.getConfigKey();
    @CatalogConfig(label="Open Ports", priority=70.0)
    @SetFromFlag(value="openPorts")
    public static final ConfigKey<String> OPEN_PORTS = ConfigKeys.newStringConfigKey((String)"docker.openPorts", (String)"Comma separated list of ports the application uses");
    @CatalogConfig(label="Direct Ports", priority=70.0)
    @SetFromFlag(value="directPorts")
    public static final ConfigKey<String> DIRECT_PORTS = ConfigKeys.newStringConfigKey((String)"docker.directPorts", (String)"Comma separated list of ports to open directly on the host");
    @SetFromFlag(value="portBindings")
    public static final ConfigKey<Map<Integer, Integer>> PORT_BINDINGS = DockerAttributes.DOCKER_PORT_BINDINGS;
    @SetFromFlag(value="env")
    public static final ConfigKey<Map<String, Object>> DOCKER_CONTAINER_ENVIRONMENT = DockerContainer.DOCKER_CONTAINER_ENVIRONMENT.getConfigKey();
    @SetFromFlag(value="volumeMappings")
    public static final ConfigKey<Map<String, String>> DOCKER_HOST_VOLUME_MAPPING = DockerHost.DOCKER_HOST_VOLUME_MAPPING.getConfigKey();
    public static final ConfigKey<String> ONBOX_BASE_DIR = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.ONBOX_BASE_DIR, (Object)"/tmp/brooklyn");
    public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, (Object)Boolean.TRUE);
}

