/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.weave;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractGroup;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.sdn.weave.WeaveContainer;
import brooklyn.networking.sdn.weave.WeaveContainerDriver;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Cidr;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.Tasks;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeaveContainerSshDriver
extends AbstractSoftwareProcessSshDriver
implements WeaveContainerDriver {
    private static final Logger LOG = LoggerFactory.getLogger(WeaveContainer.class);

    public WeaveContainerSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public String getWeaveCommand() {
        return Os.mergePathsUnix((String[])new String[]{this.getInstallDir(), "weave"});
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
    }

    public void install() {
        LinkedList commands = Lists.newLinkedList();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)this.resolver.getTargets(), (String)this.getWeaveCommand()));
        commands.add("chmod 755 " + this.getWeaveCommand());
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript("customizing").execute();
    }

    public void launch() {
        InetAddress address = (InetAddress)this.getEntity().getAttribute(WeaveContainer.SDN_AGENT_ADDRESS);
        Boolean firstMember = (Boolean)this.getEntity().getAttribute(AbstractGroup.FIRST_MEMBER);
        Entity first = (Entity)this.getEntity().getAttribute(AbstractGroup.FIRST);
        LOG.info("Launching {} Weave service at {}", (Object)(Boolean.TRUE.equals(firstMember) ? "first" : "next"), (Object)address.getHostAddress());
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)BashCommands.sudo((String)String.format("%s launch %s", this.getWeaveCommand(), Boolean.TRUE.equals(firstMember) ? "" : (String)first.getAttribute(Attributes.SUBNET_ADDRESS)))).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        ((DockerHostLocation)((DockerHost)this.getEntity().getAttribute(SdnAgent.DOCKER_HOST)).getDynamicLocation()).getLock().lock();
        try {
            boolean bl = this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)BashCommands.sudo((String)(this.getWeaveCommand() + " status"))).execute() == 0;
            return bl;
        }
        finally {
            ((DockerHostLocation)((DockerHost)this.getEntity().getAttribute(SdnAgent.DOCKER_HOST)).getDynamicLocation()).getLock().unlock();
        }
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)BashCommands.sudo((String)(this.getWeaveCommand() + " stop"))).execute();
    }

    @Override
    public void createSubnet(String svirtualNetworkId, String subnetId, Cidr subnetCidr) {
        LOG.debug("Nothing to do for Weave subnet creation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress attachNetwork(String containerId, String subnetId) {
        Tasks.setBlockingDetails((String)String.format("Attach %s to %s", containerId, subnetId));
        try {
            Cidr cidr = ((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getSubnetCidr(subnetId);
            InetAddress address = ((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getNextContainerAddress(subnetId);
            ((WeaveContainer)this.getEntity()).getDockerHost().execCommand(BashCommands.sudo((String)String.format("%s attach %s/%d %s", this.getWeaveCommand(), address.getHostAddress(), cidr.getLength(), containerId)));
            InetAddress inetAddress = address;
            return inetAddress;
        }
        finally {
            Tasks.resetBlockingDetails();
        }
    }
}

