/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn.ibm;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskFactory;
import brooklyn.networking.VirtualNetwork;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.sdn.ibm.SdnVeAgent;
import brooklyn.networking.sdn.ibm.SdnVeAgentDriver;
import brooklyn.networking.sdn.ibm.SdnVeAttributes;
import brooklyn.networking.sdn.ibm.SdnVeNetwork;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Cidr;
import brooklyn.util.net.Urls;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.StringPredicates;
import brooklyn.util.text.Strings;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdnVeAgentSshDriver
extends AbstractSoftwareProcessSshDriver
implements SdnVeAgentDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SdnVeAgent.class);

    public SdnVeAgentSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
    }

    public void install() {
        LinkedList commands = Lists.newLinkedList();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)this.resolver.getTargets(), (String)"dove-agent.rpm"));
        commands.add(BashCommands.INSTALL_CURL);
        commands.add(BashCommands.installPackage((Map)MutableMap.builder().put((Object)"yum", (Object)"iotop libvirt libvirt-python iproute").put((Object)"apt", (Object)"iotop libvirt-bin libvirt-dev python-libvirt iproute2 rpm").build(), null));
        commands.add(BashCommands.sudo((String)"rpm --nodeps --install dove-agent.rpm"));
        commands.add("wget https://repos.fedorapeople.org/repos/openstack/openstack-icehouse/epel-6/iproute-2.6.32-130.el6ost.netns.2.x86_64.rpm");
        commands.add(BashCommands.sudo((String)"rpm -Uvh iproute-2.6.32-130.el6ost.netns.2.x86_64.rpm"));
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        String netstat = ((DockerHost)this.getEntity().getAttribute((AttributeSensor)SdnVeAgent.DOCKER_HOST)).execCommand("netstat -rn");
        Iterable routes = Iterables.filter((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).split((CharSequence)netstat), (Predicate)StringPredicates.containsLiteral((String)"eth0"));
        String subnetAddress = (String)this.getEntity().getAttribute(SoftwareProcess.SUBNET_ADDRESS);
        String address = Strings.getFirstWord((String)((String)Iterables.find((Iterable)routes, (Predicate)Predicates.and((Predicate)StringPredicates.containsLiteral((String)"255.255.255."), (Predicate)StringPredicates.containsLiteral((String)subnetAddress.substring(0, subnetAddress.lastIndexOf(46)))))));
        String gateway = Strings.getFirstWordAfter((String)((String)Iterables.find((Iterable)routes, (Predicate)StringPredicates.containsLiteral((String)"10.0.0.0"))), (String)"10.0.0.0");
        LOG.debug("Found gateway {} and address {}", (Object)gateway, (Object)address);
        LinkedList commands = Lists.newLinkedList();
        commands.add(BashCommands.sudo((String)"brctl addbr br_mgmt_1"));
        commands.add(BashCommands.sudo((String)String.format("ifconfig br_mgmt_1 %s netmask 255.255.255.224", ((InetAddress)this.getEntity().getAttribute(SdnAgent.SDN_AGENT_ADDRESS)).getHostAddress())));
        commands.add(BashCommands.sudo((String)"ifconfig eth0 0.0.0.0"));
        commands.add(BashCommands.sudo((String)String.format("ifconfig br_mgmt_1:1 %s netmask 255.255.255.192", address)));
        commands.add(BashCommands.sudo((String)"brctl addif br_mgmt_1 eth0"));
        commands.add(BashCommands.sudo((String)String.format("route add -net 10.0.0.0 netmask 255.0.0.0 gw %s", gateway)));
        commands.add(BashCommands.sudo((String)"mv /etc/sysconfig/network-scripts/ifcfg-eth0 /etc/sysconfig/network-scripts/_ifcfg-eth0"));
        commands.add(BashCommands.ok((String)BashCommands.sudo((String)"service dhcpd stop")));
        commands.add(BashCommands.alternatives((String[])new String[]{BashCommands.sudo((String)"service libvirtd start"), BashCommands.sudo((String)"service libvirt-bin start"), "true"}));
        commands.add("echo 'nameserver 8.8.8.8' | " + BashCommands.sudo((String)"tee /etc/resolv.conf"));
        this.newScript((String)"customizing").body.append((Collection)commands).execute();
        String doveXmlTemplate = this.processTemplate((String)this.entity.config().get(SdnVeNetwork.CONFIGURATION_XML_TEMPLATE));
        String savedDoveXml = Urls.mergePaths((String[])new String[]{this.getRunDir(), "dove.xml"});
        DynamicTasks.queueIfPossible((TaskFactory)SshEffectorTasks.put((String)savedDoveXml).contents(doveXmlTemplate)).andWaitForSuccess();
        String networkScriptUrl = (String)this.getEntity().config().get(SdnVeNetwork.NETWORK_SETUP_SCRIPT_URL);
        String networkScript = Urls.mergePaths((String[])new String[]{this.getRunDir(), "network.sh"});
        DynamicTasks.queueIfPossible((TaskFactory)SshEffectorTasks.put((String)networkScript).contents(this.resource.getResourceFromUrl(networkScriptUrl))).andWaitForSuccess();
        this.newScript((String)"customizing").body.append((CharSequence)BashCommands.sudo((String)new StringBuilder().append((String)"mv ").append((String)savedDoveXml).append((String)" /etc/dove.xml").toString())).body.append((CharSequence)("chmod 755 " + networkScript)).execute();
    }

    private int createNetwork() {
        String networkId;
        String tenantId = networkId = this.getEntity().getApplicationId();
        ImmutableMap createNetworkData = ImmutableMap.builder().put((Object)"networkId", (Object)networkId).put((Object)"networkName", (Object)networkId).put((Object)"tenantId", (Object)tenantId).build();
        String createNetwork = this.copyJsonTemplate("create_network.json", (Map<String, String>)createNetworkData);
        this.callRestApi(createNetwork, "v2.0/networks");
        int doveNetworkId = this.getNetworkIdForName(networkId);
        return doveNetworkId;
    }

    private void createSubnet(String subnetId, String subnetName, InetAddress gatewayIp, Cidr subnetCidr) {
        String networkId;
        String tenantId = networkId = this.getEntity().getApplicationId();
        ImmutableMap createSubnetData = ImmutableMap.builder().put((Object)"subnetId", (Object)subnetId).put((Object)"subnetName", (Object)subnetName).put((Object)"networkId", (Object)networkId).put((Object)"gatewayIp", (Object)gatewayIp.getHostAddress()).put((Object)"networkCidr", (Object)subnetCidr.toString()).put((Object)"tenantId", (Object)tenantId).build();
        String createSubnet = this.copyJsonTemplate("create_subnet.json", (Map<String, String>)createSubnetData);
        this.callRestApi(createSubnet, "v2.0/subnets");
    }

    private String copyJsonTemplate(String fileName, Map<String, String> substitutions) {
        String contents = this.processTemplate("classpath://brooklyn/networking/sdn/ibm/" + fileName, substitutions);
        String target = Urls.mergePaths((String[])new String[]{this.getRunDir(), Identifiers.makeRandomId((int)8) + ".json"});
        DynamicTasks.queueIfPossible((TaskFactory)SshEffectorTasks.put((String)target).machine(this.getMachine()).contents(contents)).andWaitForSuccess();
        return target;
    }

    private String callRestApi(String jsonData, String apiPath) {
        String command = String.format("curl -i -u %s:%s -X POST -H \"Content-Type: application/json\" -d @- http://%s/%s < %s", this.getEntity().config().get(SdnVeNetwork.DOVE_CONTROLLER_USERNAME), this.getEntity().config().get(SdnVeNetwork.DOVE_CONTROLLER_PASSWORD), ((InetAddress)this.getEntity().config().get(SdnVeNetwork.DOVE_CONTROLLER)).getHostAddress(), apiPath, jsonData);
        String output = ((DockerHost)this.getEntity().getAttribute((AttributeSensor)SdnVeAgent.DOCKER_HOST)).execCommand(command);
        return output;
    }

    private int getNetworkIdForName(String networkName) {
        String command = String.format("curl -s -u %s:%s http://%s/networks", this.getEntity().config().get(SdnVeNetwork.DOVE_CONTROLLER_USERNAME), this.getEntity().config().get(SdnVeNetwork.DOVE_CONTROLLER_PASSWORD), ((InetAddress)this.getEntity().config().get(SdnVeNetwork.DOVE_CONTROLLER)).getHostAddress());
        String output = ((DockerHost)this.getEntity().getAttribute((AttributeSensor)SdnVeAgent.DOCKER_HOST)).execCommand(command);
        JsonParser parser = new JsonParser();
        JsonElement json = parser.parse(output);
        JsonArray networks = json.getAsJsonObject().get("networks").getAsJsonArray();
        for (JsonElement element : networks) {
            JsonObject network = element.getAsJsonObject();
            int networkId = network.get("network_id").getAsInt();
            int domainId = network.get("domain_id").getAsInt();
            String name = network.get("name").getAsString();
            if (!name.endsWith(networkName)) continue;
            this.getEntity().setAttribute(SdnVeAgent.DOVE_BRIDGE_ID, (Object)networkId);
            this.getEntity().setAttribute(SdnVeAgent.DOVE_DOMAIN_ID, (Object)domainId);
            return networkId;
        }
        throw new IllegalStateException("Cannot find network: " + networkName);
    }

    private void attachPublicAddress(String containerId, InetAddress privateAddress, InetAddress publicAddress) {
        ImmutableMap createSnatRulesData = ImmutableMap.builder().put((Object)"networkId", (Object)Integer.toString((Integer)this.getEntity().getAttribute(SdnVeAgent.DOVE_BRIDGE_ID))).put((Object)"domainId", (Object)Integer.toString((Integer)this.getEntity().getAttribute(SdnVeAgent.DOVE_DOMAIN_ID))).build();
        String createSnatRules = this.copyJsonTemplate("create_snat_rules.json", (Map<String, String>)createSnatRulesData);
        this.callRestApi(createSnatRules, "api/dove/dgw/service/ext-gw");
        ImmutableMap createForwarduingRuleData = ImmutableMap.builder().put((Object)"networkId", (Object)Integer.toString((Integer)this.getEntity().getAttribute(SdnVeAgent.DOVE_BRIDGE_ID))).put((Object)"sourceIp", (Object)privateAddress.getHostAddress()).put((Object)"targetIp", (Object)publicAddress.getHostAddress()).build();
        String createForwarduingRule = this.copyJsonTemplate("create_forwarding_rule.json", (Map<String, String>)createForwarduingRuleData);
        this.callRestApi(createForwarduingRule, "api/dove/dgw/service/rule");
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append((CharSequence)BashCommands.sudo((String)"start doved")).execute();
        int networkId = this.createNetwork();
        ImmutableMap createBridgeData = ImmutableMap.builder().put((Object)"networkId", (Object)Integer.toString(networkId)).put((Object)"agentAddress", (Object)((InetAddress)this.getEntity().getAttribute(SdnAgent.SDN_AGENT_ADDRESS)).getHostAddress()).build();
        String createBridge = this.copyJsonTemplate("create_bridge.json", (Map<String, String>)createBridgeData);
        String createBridgeOutput = this.callRestApi(createBridge, "api/dove/vrmgr/vnids/vm_mgr");
        Preconditions.checkState((boolean)Strings.containsLiteral((CharSequence)createBridgeOutput, (CharSequence)"successfully"), (String)"Failed to export network %s", (Object[])new Object[]{networkId});
        String bridge = ((DockerHost)this.getEntity().getAttribute((AttributeSensor)SdnVeAgent.DOCKER_HOST)).execCommand(BashCommands.sudo((String)"brctl show"));
        String doveBridge = Strings.getFirstWordAfter((String)bridge, (String)"dovebr_");
        if (Integer.valueOf(doveBridge) != networkId) {
            throw new IllegalStateException("Incorrect network ID found: " + doveBridge);
        }
        LOG.debug("Added bridge: " + doveBridge);
        LOG.info("SDN agent restarting Docker service");
        String restart = ((DockerHost)this.getEntity().getAttribute((AttributeSensor)SdnVeAgent.DOCKER_HOST)).execCommand(BashCommands.sudo((String)"service docker restart"));
        Iterable successes = Iterables.filter((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).split((CharSequence)restart), (Predicate)StringPredicates.containsLiteral((String)"OK"));
        if (Iterables.size((Iterable)successes) != 2) {
            throw new IllegalStateException("Failed to restart Docker Engine service: " + restart);
        }
    }

    public boolean isRunning() {
        String pingData = ((DockerHost)this.getEntity().getAttribute((AttributeSensor)SdnVeAgent.DOCKER_HOST)).execCommand(String.format("ping -c 10 -q %s", ((InetAddress)this.getEntity().config().get(SdnVeNetwork.DOVE_CONTROLLER)).getHostAddress()));
        Double packetLoss = (double)Integer.valueOf(Strings.getFirstWordAfter((String)pingData, (String)"packets transmitted,")).intValue() / 10.0;
        ScriptHelper helper = this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)BashCommands.sudo((String)"status doved")).noExtraOutput().gatherOutput();
        helper.execute();
        return helper.getResultStdout().contains("running");
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)BashCommands.sudo((String)"stop doved")).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSubnet(String virtualNetworkId, String subnetId, Cidr subnetCidr) {
        Tasks.setBlockingDetails((String)("Creating " + subnetId));
        try {
            InetAddress gatewayIp = subnetCidr.addressAtOffset(1);
            this.createSubnet(virtualNetworkId, subnetId, gatewayIp, subnetCidr);
        }
        finally {
            Tasks.resetBlockingDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress attachNetwork(String containerId, String subnetId) {
        Tasks.setBlockingDetails((String)String.format("Attach %s to %s", containerId, subnetId));
        try {
            InetAddress address = ((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getNextContainerAddress(subnetId);
            String networkScript = Urls.mergePaths((String[])new String[]{this.getRunDir(), "network.sh"});
            Integer bridgeId = (Integer)this.getEntity().getAttribute(SdnVeAgent.DOVE_BRIDGE_ID);
            Cidr cidr = ((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getSubnetCidr(subnetId);
            String command = String.format("%s %s %s %s fa:16:%02x:%02x:%02x:%02x %s/%d %s %d %s", networkScript, containerId, this.getEntity().getApplicationId(), Identifiers.makeRandomId((int)8), address.getAddress()[0], address.getAddress()[1], address.getAddress()[2], address.getAddress()[3], address.getHostAddress(), cidr.getLength(), cidr.addressAtOffset(1).getHostAddress(), bridgeId, subnetId);
            ((DockerHost)this.getEntity().config().get((ConfigKey.HasConfigKey)SdnVeAgent.DOCKER_HOST)).execCommand(BashCommands.sudo((String)command));
            Optional found = Iterables.tryFind((Iterable)((Group)((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getAttribute(SdnProvider.SDN_NETWORKS)).getMembers(), (Predicate)EntityPredicates.attributeEqualTo(VirtualNetwork.NETWORK_ID, (Object)subnetId));
            if (!found.isPresent()) {
                throw new IllegalStateException(String.format("Cannot find virtual network entity for %s", subnetId));
            }
            VirtualNetwork network = (VirtualNetwork)found.get();
            if (Boolean.TRUE.equals(network.config().get(SdnVeAttributes.ENABLE_PUBLIC_ACCESS))) {
                Cidr publicCidr = (Cidr)network.config().get(SdnVeAttributes.PUBLIC_CIDR);
                ((SdnProvider)this.getEntity().getAttribute((AttributeSensor)SdnVeAgent.SDN_PROVIDER)).recordSubnetCidr(subnetId + ".public", publicCidr, -1);
                InetAddress publicAddress = ((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getNextContainerAddress(subnetId + ".public");
                this.attachPublicAddress(containerId, address, publicAddress);
                Collection containers = ((DynamicGroup)((Entity)((SdnProvider)this.getEntity().getAttribute(SdnAgent.SDN_PROVIDER)).getAttribute((AttributeSensor)SdnProvider.DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.DOCKER_CONTAINER_FABRIC)).getMembers();
                Optional container = Iterables.tryFind((Iterable)Iterables.filter((Iterable)containers, DockerContainer.class), (Predicate)EntityPredicates.attributeEqualTo(DockerContainer.CONTAINER_ID, (Object)containerId));
                if (!container.isPresent()) {
                    throw new IllegalStateException(String.format("Cannot find container entity for %s", containerId));
                }
                ((EntityLocal)container.get()).setAttribute(SdnVeAttributes.PUBLIC_CIDR, (Object)publicCidr);
                ((EntityLocal)container.get()).setAttribute(SdnVeAttributes.PUBLIC_ADDRESS, (Object)publicAddress);
            }
            InetAddress inetAddress = address;
            return inetAddress;
        }
        finally {
            Tasks.resetBlockingDetails();
        }
    }
}

