/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.networking.sdn;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.BasicGroup;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.location.docker.DockerLocation;
import brooklyn.networking.VirtualNetwork;
import brooklyn.networking.location.NetworkProvisioningExtension;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.policy.PolicySpec;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.net.Cidr;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdnProviderImpl
extends BasicStartableImpl
implements SdnProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SdnProvider.class);
    protected final transient Object addressMutex = new Object[0];
    protected final transient Object hostMutex = new Object[0];
    protected final transient Object networkMutex = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LOG.info("Starting SDN provider id {}", (Object)this.getId());
        super.init();
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)DOCKER_INFRASTRUCTURE);
        BasicGroup agents = (BasicGroup)this.addChild((EntitySpec)EntitySpec.create(BasicGroup.class).configure(BasicGroup.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).configure(BasicGroup.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).displayName("SDN Host Agents"));
        BasicGroup networks = (BasicGroup)this.addChild((EntitySpec)EntitySpec.create(BasicGroup.class).configure(BasicGroup.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).configure(BasicGroup.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).configure(BasicGroup.MEMBER_DELEGATE_CHILDREN, (Object)true).displayName("SDN Managed Networks"));
        BasicGroup applications = (BasicGroup)this.addChild((EntitySpec)EntitySpec.create(BasicGroup.class).configure(BasicGroup.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).configure(BasicGroup.UP_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty()).displayName("SDN Networked Applications"));
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)agents);
            Entities.manage((Entity)networks);
            Entities.manage((Entity)applications);
        }
        this.setAttribute(SDN_AGENTS, agents);
        this.setAttribute(SDN_NETWORKS, networks);
        this.setAttribute(SDN_APPLICATIONS, applications);
        Object object = this.addressMutex;
        synchronized (object) {
            this.setAttribute(ALLOCATED_IPS, 0);
            this.setAttribute(ALLOCATED_ADDRESSES, Maps.newConcurrentMap());
            this.setAttribute(SUBNET_ADDRESS_ALLOCATIONS, Maps.newConcurrentMap());
        }
        object = this.networkMutex;
        synchronized (object) {
            this.setAttribute(ALLOCATED_NETWORKS, 0);
            this.setAttribute(SUBNETS, Maps.newConcurrentMap());
        }
        this.setAttribute(SUBNET_ENTITIES, Maps.newConcurrentMap());
        this.setAttribute(CONTAINER_ADDRESSES, HashMultimap.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getNextAgentAddress(String agentId) {
        Object object = this.addressMutex;
        synchronized (object) {
            Cidr cidr = (Cidr)this.config().get(AGENT_CIDR);
            Integer allocated = (Integer)this.getAttribute(ALLOCATED_IPS);
            InetAddress next = cidr.addressAtOffset(allocated + 1);
            this.setAttribute(ALLOCATED_IPS, allocated + 1);
            Map addresses = (Map)this.getAttribute(ALLOCATED_ADDRESSES);
            addresses.put(agentId, next);
            this.setAttribute(ALLOCATED_ADDRESSES, addresses);
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getNextContainerAddress(String subnetId) {
        Cidr cidr = this.getSubnetCidr(subnetId);
        Object object = this.addressMutex;
        synchronized (object) {
            Map allocations = (Map)this.getAttribute(SUBNET_ADDRESS_ALLOCATIONS);
            Integer allocated = (Integer)allocations.get(subnetId);
            if (allocated == null) {
                allocated = 1;
            }
            InetAddress next = cidr.addressAtOffset(allocated + 1);
            allocations.put(subnetId, allocated + 1);
            this.setAttribute(SUBNET_ADDRESS_ALLOCATIONS, allocations);
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cidr getNextSubnetCidr(String networkId) {
        Object object = this.networkMutex;
        synchronized (object) {
            Cidr networkCidr = this.getNextSubnetCidr();
            this.recordSubnetCidr(networkId, networkCidr);
            return networkCidr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cidr getNextSubnetCidr() {
        Object object = this.networkMutex;
        synchronized (object) {
            Cidr networkCidr = (Cidr)this.config().get(CONTAINER_NETWORK_CIDR);
            Integer networkSize = (Integer)this.config().get(CONTAINER_NETWORK_SIZE);
            Integer allocated = (Integer)this.getAttribute(ALLOCATED_NETWORKS);
            InetAddress baseAddress = networkCidr.addressAtOffset(allocated * (1 << 32 - networkSize));
            Cidr subnetCidr = new Cidr(baseAddress.getHostAddress() + "/" + networkSize);
            LOG.debug("Allocated {} from {} for subnet #{}", new Object[]{subnetCidr, networkCidr, allocated});
            this.setAttribute(ALLOCATED_NETWORKS, allocated + 1);
            return subnetCidr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordSubnetCidr(String networkId, Cidr subnetCidr) {
        Object object = this.networkMutex;
        synchronized (object) {
            Map subnets = (Map)this.getAttribute(SdnProvider.SUBNETS);
            subnets.put(networkId, subnetCidr);
            this.setAttribute(SdnProvider.SUBNETS, subnets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordSubnetCidr(String networkId, Cidr subnetCidr, int allocated) {
        Object object = this.networkMutex;
        synchronized (object) {
            this.recordSubnetCidr(networkId, subnetCidr);
            Map allocations = (Map)this.getAttribute(SUBNET_ADDRESS_ALLOCATIONS);
            allocations.put(networkId, allocated);
            this.setAttribute(SUBNET_ADDRESS_ALLOCATIONS, allocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cidr getSubnetCidr(String networkId) {
        Object object = this.networkMutex;
        synchronized (object) {
            Map subnets = (Map)this.getAttribute(SdnProvider.SUBNETS);
            return (Cidr)subnets.get(networkId);
        }
    }

    @Override
    public Object getNetworkMutex() {
        return this.networkMutex;
    }

    @Override
    public DynamicCluster getDockerHostCluster() {
        return (DynamicCluster)((Entity)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE)).getAttribute(DockerInfrastructure.DOCKER_HOST_CLUSTER);
    }

    @Override
    public Group getAgents() {
        return (Group)this.getAttribute(SDN_AGENTS);
    }

    public void start(Collection<? extends Location> locations) {
        this.setAttribute(SERVICE_UP, Boolean.FALSE);
        DockerInfrastructure infrastructure = (DockerInfrastructure)this.config().get((ConfigKey.HasConfigKey)DOCKER_INFRASTRUCTURE);
        ((DockerLocation)infrastructure.getDynamicLocation()).addExtension(NetworkProvisioningExtension.class, this);
        super.start(locations);
        this.addHostTrackerPolicy();
        this.setAttribute(SERVICE_UP, Boolean.TRUE);
    }

    public void stop() {
        this.setAttribute(SERVICE_UP, Boolean.FALSE);
        super.stop();
    }

    public void rebind() {
        super.rebind();
    }

    protected void addHostTrackerPolicy() {
        DynamicCluster hosts = this.getDockerHostCluster();
        if (hosts != null) {
            MemberTrackingPolicy hostTrackerPolicy = (MemberTrackingPolicy)this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Docker host tracker")).configure((CharSequence)"group", (Object)hosts));
            LOG.info("Added policy {} to {}, during start", (Object)hostTrackerPolicy, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHostAdded(Entity item) {
        Object object = this.hostMutex;
        synchronized (object) {
            if (item instanceof DockerHost) {
                this.addHost((DockerHost)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHostRemoved(Entity item) {
        Object object = this.hostMutex;
        synchronized (object) {
            if (item instanceof DockerHost) {
                this.removeHost((DockerHost)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHostChanged(Entity item) {
        Object object = this.hostMutex;
        synchronized (object) {
            boolean exists = this.getDockerHostCluster().hasMember(item);
            Boolean running = (Boolean)item.getAttribute(SERVICE_UP);
            if (exists && running.booleanValue() && item.getAttribute(SdnAgent.SDN_AGENT) == null) {
                this.onHostAdded(item);
            } else if (!exists) {
                this.onHostRemoved(item);
            }
        }
    }

    @Override
    public Map<String, Cidr> listManagedNetworkAddressSpace() {
        return ImmutableMap.copyOf((Map)((Map)this.getAttribute(SUBNETS)));
    }

    @Override
    public void provisionNetwork(VirtualNetwork network) {
        SdnAgent agent = (SdnAgent)this.getAgents().getMembers().iterator().next();
        String networkId = agent.provisionNetwork(network);
        EntitySpec networkSpec = (EntitySpec)EntitySpec.create(DynamicGroup.class).configure(DynamicGroup.ENTITY_FILTER, (Object)Predicates.and((Predicate[])new Predicate[]{Predicates.not((Predicate)Predicates.or((Predicate)Predicates.instanceOf(DockerContainer.class), (Predicate)Predicates.instanceOf(DelegateEntity.class))), EntityPredicates.attributeEqualTo(DockerContainer.DOCKER_INFRASTRUCTURE, (Object)this.getAttribute((AttributeSensor)DOCKER_INFRASTRUCTURE)), SdnAttributes.attachedToNetwork(networkId)})).configure(DynamicGroup.MEMBER_DELEGATE_CHILDREN, (Object)true).displayName(network.getDisplayName());
        DynamicGroup subnet = (DynamicGroup)((Group)this.getAttribute(SDN_APPLICATIONS)).addMemberChild(networkSpec);
        Entities.manage((Entity)subnet);
        ((EntityLocal)subnet).setAttribute(VirtualNetwork.NETWORK_ID, (Object)networkId);
        ((EntityLocal)network).setAttribute(VirtualNetwork.NETWORKED_APPLICATIONS, (Object)subnet);
        ((Group)this.getAttribute(SDN_NETWORKS)).addMember((Entity)network);
    }

    @Override
    public void deallocateNetwork(VirtualNetwork network) {
        String networkId = (String)network.getAttribute((AttributeSensor)VirtualNetwork.NETWORK_ID);
        Optional found = Iterables.tryFind((Iterable)((Group)this.getAttribute(SDN_APPLICATIONS)).getMembers(), (Predicate)EntityPredicates.attributeEqualTo(VirtualNetwork.NETWORK_ID, (Object)networkId));
        if (found.isPresent()) {
            Entity group = (Entity)found.get();
            ((Group)this.getAttribute(SDN_APPLICATIONS)).removeMember(group);
            ((Group)this.getAttribute(SDN_APPLICATIONS)).removeChild(group);
            Entities.unmanage((Entity)group);
        } else {
            LOG.warn("Cannot find group containing {} network entities", (Object)networkId);
        }
        ((Group)this.getAttribute(SDN_NETWORKS)).removeMember((Entity)network);
    }

    static {
        RendererHints.register((AttributeSensor)SDN_AGENTS, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_NETWORKS, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)SDN_APPLICATIONS, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register((AttributeSensor)DOCKER_INFRASTRUCTURE, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
            ((SdnProviderImpl)this.entity).onHostChanged(member);
        }
    }
}

