/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.location.HardwareDetails;
import brooklyn.location.Location;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.AbstractDockerPlacementStrategy;
import brooklyn.location.docker.strategy.DockerAwareProvisioningStrategy;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningFlagsPlacementStrategy
extends AbstractDockerPlacementStrategy
implements DockerAwareProvisioningStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisioningFlagsPlacementStrategy.class);
    public static final ConfigKey<Object> MIN_RAM = CloudLocationConfig.MIN_RAM;
    public static final ConfigKey<Integer> MIN_CORES = CloudLocationConfig.MIN_CORES;

    @Override
    public List<DockerHostLocation> filterLocations(List<DockerHostLocation> locations, Entity context) {
        if (locations == null || locations.isEmpty()) {
            return ImmutableList.of();
        }
        Integer strategyMinRam = (Integer)this.config().get(MIN_RAM);
        Integer strategyMinCores = (Integer)this.config().get(MIN_CORES);
        Map contextFlags = (Map)context.config().get((ConfigKey)SoftwareProcess.PROVISIONING_PROPERTIES);
        if (contextFlags == null || contextFlags.isEmpty()) {
            return locations;
        }
        Integer contextMinRam = (Integer)contextFlags.get("minRam");
        Integer contextMinCores = (Integer)contextFlags.get("minCores");
        int minRam = this.max(strategyMinRam, contextMinRam);
        int minCores = this.max(strategyMinCores, contextMinCores);
        LOG.info("Provisioning strategy RAM {}, cores {}", (Object)minRam, (Object)minCores);
        MutableList available = MutableList.of();
        for (DockerHostLocation location : locations) {
            HardwareDetails details = location.getMachine().getMachineDetails().getHardwareDetails();
            if (details.getCpuCount() <= minCores || details.getRam() <= minRam) continue;
            Collection entities = this.getBrooklynManagementContext().getEntityManager().findEntities(EntityPredicates.locationsIncludes((Location)location));
            int ramUsed = 0;
            int coresUsed = 0;
            for (Entity entity : entities) {
                Map entityFlags = (Map)entity.config().get((ConfigKey)SoftwareProcess.PROVISIONING_PROPERTIES);
                LOG.info("Checking provisioning flags on {}: {}", (Object)entity, (Object)entityFlags);
                if (entityFlags == null || entityFlags.isEmpty()) continue;
                Integer entityMinRam = (Integer)entityFlags.get("minRam");
                Integer entityMinCores = (Integer)entityFlags.get("minCores");
                ramUsed += entityMinRam == null ? 0 : entityMinRam;
                coresUsed += entityMinCores == null ? 0 : entityMinCores;
            }
            if (details.getCpuCount() - coresUsed <= minCores || details.getRam() - ramUsed <= minRam) continue;
            available.add(location);
        }
        return ImmutableList.copyOf((Collection)available);
    }

    @Override
    public Map<String, Object> apply(Map<String, Object> contextFlags) {
        Integer strategyMinRam = (Integer)this.config().get(MIN_RAM);
        Integer strategyMinCores = (Integer)this.config().get(MIN_CORES);
        LinkedHashMap provisioningFlags = contextFlags != null ? MutableMap.copyOf(contextFlags) : Maps.newLinkedHashMap();
        Integer contextMinRam = (Integer)provisioningFlags.get("minRam");
        Integer contextMinCores = (Integer)provisioningFlags.get("minCores");
        int minRam = this.max(strategyMinRam, contextMinRam);
        int minCores = this.max(strategyMinCores, contextMinCores);
        provisioningFlags.put("minRam", minRam);
        provisioningFlags.put("minCores", minCores);
        return provisioningFlags;
    }

    private Integer max(Integer one, Integer two) {
        return Math.max(one == null ? 0 : one, two == null ? 0 : two);
    }
}

