/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker.strategy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.location.docker.DockerHostLocation;
import brooklyn.location.docker.strategy.BasicDockerPlacementStrategy;
import brooklyn.util.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxCpuUsagePlacementStrategy
extends BasicDockerPlacementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MaxCpuUsagePlacementStrategy.class);
    @SetFromFlag(value="maxCpuUsage")
    public static final ConfigKey<Double> DOCKER_CONTAINER_CLUSTER_MAX_CPU = ConfigKeys.newDoubleConfigKey((String)"docker.container.cluster.maxCpu", (String)"Maximum CPU usage across a Docker container cluster");
    public static final Double DEFAULT_MAX_CPU_USAGE = 0.5;

    @Override
    public boolean apply(DockerHostLocation input) {
        Double infrastructureMax;
        Double maxCpu = (Double)this.config().get(DOCKER_CONTAINER_CLUSTER_MAX_CPU);
        DockerInfrastructure infrastructure = (DockerInfrastructure)this.config().get(DOCKER_INFRASTRUCTURE);
        if (infrastructure != null && (infrastructureMax = (Double)infrastructure.config().get(DOCKER_CONTAINER_CLUSTER_MAX_CPU)) != null) {
            maxCpu = infrastructureMax;
        }
        if (maxCpu == null) {
            maxCpu = DEFAULT_MAX_CPU_USAGE;
        }
        Boolean serviceUp = (Boolean)input.getOwner().getAttribute(SoftwareProcess.SERVICE_UP);
        Double currentCpu = (Double)input.getOwner().getAttribute(DockerHost.CPU_USAGE);
        if (!Boolean.TRUE.equals(serviceUp) || currentCpu == null) {
            return false;
        }
        boolean accept = currentCpu < maxCpu;
        LOG.debug("Location {} CPU usage is {}: {}", new Object[]{input, currentCpu, accept ? "accepted" : "rejected"});
        return accept;
    }
}

