/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.docker;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityAndAttribute;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.container.DockerAttributes;
import brooklyn.entity.container.DockerCallbacks;
import brooklyn.entity.container.DockerUtils;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.DockerInfrastructure;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.location.Location;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerContainerLocation;
import brooklyn.location.docker.DockerLocation;
import brooklyn.location.docker.DockerVirtualLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.networking.common.subnet.PortForwarder;
import brooklyn.networking.sdn.SdnAgent;
import brooklyn.networking.sdn.SdnAttributes;
import brooklyn.networking.sdn.SdnProvider;
import brooklyn.networking.subnet.SubnetTier;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Cidr;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.text.Strings;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHostLocation
extends AbstractLocation
implements MachineProvisioningLocation<DockerContainerLocation>,
DockerVirtualLocation,
DynamicLocation<DockerHost, DockerHostLocation>,
Closeable {
    private static final long serialVersionUID = -1453203257759956820L;
    private static final Logger LOG = LoggerFactory.getLogger(DockerHostLocation.class);
    public static final String CONTAINER_MUTEX = "container";
    private transient ReadWriteLock lock = new ReentrantReadWriteLock();
    @SetFromFlag(value="machine")
    private SshMachineLocation machine;
    @SetFromFlag(value="jcloudsLocation")
    private JcloudsLocation jcloudsLocation;
    @SetFromFlag(value="portForwarder")
    private PortForwarder portForwarder;
    @SetFromFlag(value="owner")
    private DockerHost dockerHost;
    @SetFromFlag(value="images")
    private ConcurrentMap<String, CountDownLatch> images = Maps.newConcurrentMap();

    public DockerHostLocation() {
        this(Maps.newLinkedHashMap());
    }

    public DockerHostLocation(Map properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            this.init();
        }
    }

    public DockerContainerLocation obtain() throws NoMachinesAvailableException {
        return this.obtain(Maps.newLinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerContainerLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        this.lock.readLock().lock();
        try {
            Object context = flags.get(LocationConfigKeys.CALLER_CONTEXT.getName());
            if (context == null || !(context instanceof Entity)) {
                throw new IllegalStateException("Invalid location context: " + context);
            }
            Entity entity = (Entity)context;
            LOG.info("Configuring entity {} via subnet {}", (Object)entity, (Object)this.dockerHost.getSubnetTier());
            entity.config().set(SubnetTier.PORT_FORWARDING_MANAGER, (Object)this.dockerHost.getSubnetTier().getPortForwardManager());
            entity.config().set(SubnetTier.PORT_FORWARDER, (Object)this.portForwarder);
            if (((Boolean)this.getOwner().config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                SdnAgent agent = (SdnAgent)this.getOwner().getAttribute(SdnAgent.SDN_AGENT);
                if (agent == null) {
                    throw new IllegalStateException("SDN agent entity on " + this.getOwner() + " is null");
                }
                Map networks = (Map)((SdnProvider)agent.getAttribute((AttributeSensor)SdnAgent.SDN_PROVIDER)).getAttribute(SdnProvider.SUBNETS);
                entity.config().set(SubnetTier.SUBNET_CIDR, networks.get(entity.getApplicationId()));
            } else {
                entity.config().set(SubnetTier.SUBNET_CIDR, (Object)Cidr.UNIVERSAL);
            }
            this.configureEnrichers(entity);
            String dockerfile = (String)entity.config().get(DockerAttributes.DOCKERFILE_URL);
            String imageId = (String)entity.config().get(DockerAttributes.DOCKER_IMAGE_ID);
            Optional baseImage = Optional.fromNullable((Object)entity.config().get(DockerAttributes.DOCKER_IMAGE_NAME));
            String imageTag = (String)Optional.fromNullable((Object)entity.config().get(DockerAttributes.DOCKER_IMAGE_TAG)).or((Object)"latest");
            String imageName = DockerUtils.imageName(entity, dockerfile);
            LOG.info("ImageName for entity {}: {}", (Object)entity, (Object)imageName);
            if (this.dockerHost.getImageNamed(imageName, imageTag).isPresent()) {
                this.waitForImage(imageName);
                imageId = (String)this.dockerHost.getImageNamed(imageName, imageTag).get();
                LOG.info("Found image {} for entity: {}", (Object)imageName, (Object)imageId);
                entity.config().set(SoftwareProcess.SKIP_INSTALLATION, (Object)true);
            } else if (baseImage.isPresent()) {
                imageId = this.dockerHost.layerSshableImageOn((String)baseImage.get(), imageTag);
                LOG.info("Created SSHable image from {}: {}", baseImage.get(), (Object)imageId);
                entity.config().set(SoftwareProcess.SKIP_INSTALLATION, (Object)true);
            } else {
                this.insertCallback(entity, (ConfigKey<String>)SoftwareProcess.POST_INSTALL_COMMAND, DockerCallbacks.commit());
                if (Strings.isNonBlank((CharSequence)dockerfile)) {
                    if (imageId != null) {
                        LOG.warn("Ignoring container imageId {} as dockerfile URL is set: {}", (Object)imageId, (Object)dockerfile);
                    }
                    imageId = this.dockerHost.createSshableImage(dockerfile, imageName);
                }
                if (Strings.isBlank((CharSequence)imageId)) {
                    imageId = (String)this.getOwner().getAttribute((AttributeSensor)DockerHost.DOCKER_IMAGE_ID);
                }
                this.images.putIfAbsent(imageName, new CountDownLatch(1));
                this.dockerHost.runDockerCommand(String.format("tag -f %s %s:latest", imageId, imageName));
            }
            this.insertCallback(entity, (ConfigKey<String>)SoftwareProcess.PRE_INSTALL_COMMAND, DockerCallbacks.subnetAddress());
            String hardwareId = (String)entity.config().get(DockerAttributes.DOCKER_HARDWARE_ID);
            if (Strings.isEmpty((CharSequence)hardwareId)) {
                hardwareId = (String)this.getOwner().config().get(DockerAttributes.DOCKER_HARDWARE_ID);
            }
            LOG.info("Starting container with imageId {} and hardwareId {} at {}", new Object[]{imageId, hardwareId, this.machine});
            MutableMap containerFlags = MutableMap.builder().putAll(flags).put((Object)"entity", (Object)entity).putIfNotNull((Object)"imageId", (Object)imageId).putIfNotNull((Object)"hardwareId", (Object)hardwareId).build();
            DynamicCluster cluster = this.dockerHost.getDockerContainerCluster();
            Entity added = cluster.addNode((Location)this.machine, (Map)containerFlags);
            if (added == null) {
                throw new NoMachinesAvailableException(String.format("Failed to create container at %s", this.dockerHost.getDockerHostName()));
            }
            Entities.start((Entity)added, (Collection)ImmutableList.of((Object)this.machine));
            DockerContainer dockerContainer = (DockerContainer)added;
            ((EntityLocal)dockerContainer).setAttribute(DockerContainer.IMAGE_ID, (Object)imageId);
            ((EntityLocal)dockerContainer).setAttribute(DockerContainer.IMAGE_NAME, (Object)imageName);
            ((EntityLocal)dockerContainer).setAttribute(DockerContainer.HARDWARE_ID, (Object)hardwareId);
            if (((Boolean)this.getOwner().config().get(SdnAttributes.SDN_ENABLE)).booleanValue()) {
                SdnAgent agent = (SdnAgent)this.getOwner().getAttribute(SdnAgent.SDN_AGENT);
                Cidr applicationCidr = ((SdnProvider)agent.getAttribute((AttributeSensor)SdnAgent.SDN_PROVIDER)).getSubnetCidr(entity.getApplicationId());
                ((EntityLocal)entity).setAttribute(SdnProvider.APPLICATION_CIDR, (Object)applicationCidr);
                ((EntityLocal)dockerContainer).setAttribute(SdnProvider.APPLICATION_CIDR, (Object)applicationCidr);
            }
            DockerContainerLocation dockerContainerLocation = (DockerContainerLocation)dockerContainer.getDynamicLocation();
            return dockerContainerLocation;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void insertCallback(Entity entity, ConfigKey<String> commandKey, String callback) {
        String command = (String)entity.config().get(commandKey);
        command = Strings.isNonBlank((CharSequence)command) ? BashCommands.chain((String[])new String[]{command, callback}) : callback;
        entity.config().set(commandKey, (Object)command);
    }

    public void waitForImage(String imageName) {
        try {
            CountDownLatch latch = (CountDownLatch)this.images.get(imageName);
            if (latch != null) {
                latch.await(15L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException ie) {
            throw Exceptions.propagate((Throwable)ie);
        }
    }

    public void markImage(String imageName) {
        CountDownLatch latch = (CountDownLatch)this.images.get(imageName);
        if (latch != null) {
            latch.countDown();
        }
    }

    private void configureEnrichers(Entity entity) {
        for (AttributeSensor sensor : Iterables.filter((Iterable)entity.getEntityType().getSensors(), AttributeSensor.class)) {
            Object target;
            if ((DockerUtils.URL_SENSOR_NAMES.contains(sensor.getName()) || sensor.getName().endsWith(".url") || URI.class.isAssignableFrom(sensor.getType())) && !DockerUtils.BLACKLIST_URL_SENSOR_NAMES.contains(sensor.getName())) {
                target = DockerUtils.mappedSensor(sensor);
                entity.addEnricher(this.dockerHost.getSubnetTier().uriTransformingEnricher(EntityAndAttribute.create((Entity)entity, (AttributeSensor)sensor), target));
                Set hints = RendererHints.getHintsFor((AttributeSensor)sensor);
                for (RendererHints.Hint hint : hints) {
                    RendererHints.register(target, (RendererHints.Hint)((RendererHints.NamedActionWithUrl)hint));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Mapped URL sensor: origin={}, mapped={}", (Object)sensor.getName(), (Object)target.getName());
                continue;
            }
            if (!PortAttributeSensorAndConfigKey.class.isAssignableFrom(sensor.getClass())) continue;
            target = DockerUtils.mappedPortSensor((PortAttributeSensorAndConfigKey)sensor);
            entity.addEnricher(this.dockerHost.getSubnetTier().hostAndPortTransformingEnricher(EntityAndAttribute.create((Entity)entity, (AttributeSensor)sensor), target));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Mapped port sensor: origin={}, mapped={}", (Object)sensor.getName(), (Object)target.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DockerContainerLocation machine) {
        this.lock.readLock().lock();
        try {
            LOG.info("Releasing {}", (Object)machine);
            DynamicCluster cluster = this.dockerHost.getDockerContainerCluster();
            DockerContainer container = machine.getOwner();
            if (cluster.removeMember((Entity)container)) {
                LOG.info("Docker Host {}: member {} released", (Object)this.dockerHost.getDockerHostName(), (Object)machine);
            } else {
                LOG.warn("Docker Host {}: member {} not found for release", (Object)this.dockerHost.getDockerHostName(), (Object)machine);
            }
            try {
                machine.close();
                container.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping container: " + container, (Throwable)e);
                Exceptions.propagateIfFatal((Throwable)e);
            }
            finally {
                Entities.unmanage((Entity)container);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return MutableMap.of();
    }

    public DockerHost getOwner() {
        return this.dockerHost;
    }

    public SshMachineLocation getMachine() {
        return this.machine;
    }

    public JcloudsLocation getJcloudsLocation() {
        return this.jcloudsLocation;
    }

    public PortForwarder getPortForwarder() {
        return this.portForwarder;
    }

    public int getCurrentSize() {
        return this.dockerHost.getCurrentSize();
    }

    public MachineProvisioningLocation<DockerContainerLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Entity> getDockerContainerList() {
        return this.dockerHost.getDockerContainerList();
    }

    @Override
    public List<Entity> getDockerHostList() {
        return Lists.newArrayList((Object[])new Entity[]{this.dockerHost});
    }

    @Override
    public DockerInfrastructure getDockerInfrastructure() {
        return ((DockerLocation)this.getParent()).getDockerInfrastructure();
    }

    @Override
    public void close() throws IOException {
        LOG.info("Close called on Docker host {}: {}", (Object)this.machine, (Object)this);
        try {
            this.machine.close();
        }
        catch (Exception e) {
            LOG.info("{}: Closing Docker host: {}", (Object)e.getMessage(), (Object)this);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            LOG.info("Docker host closed: {}", (Object)this);
        }
    }

    public Lock getLock() {
        return this.lock.writeLock();
    }

    public Objects.ToStringHelper string() {
        return super.string().add("machine", (Object)this.machine).add("jcloudsLocation", (Object)this.jcloudsLocation).add("dockerHost", (Object)this.dockerHost);
    }
}

