/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxy.haproxy;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.proxy.LoadBalancer;
import brooklyn.entity.proxy.haproxy.HAProxyController;
import brooklyn.entity.proxy.haproxy.HAProxyDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.guava.Maybe;
import brooklyn.util.os.Os;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HAProxySshDriver
extends AbstractSoftwareProcessSshDriver
implements HAProxyDriver {
    private static final Logger LOG = LoggerFactory.getLogger(HAProxySshDriver.class);

    public HAProxySshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void install() {
        throw new UnsupportedOperationException("Driver expected to be used in a container with HAProxy installed");
    }

    public void customize() {
        this.reconfigureService();
    }

    public void launch() {
        StringBuilder command = new StringBuilder(Os.mergePathsUnix((String[])new String[]{this.getInstallDir(), "haproxy"})).append(" -D").append(" -p ").append(this.getPidFileLocation()).append(" -f ").append(this.getConfigFileLocation()).append(" -sf ").append(" $(cat ").append(this.getPidFileLocation()).append(")");
        this.newScript((String)"launching").body.append((CharSequence)command).failOnNonZeroResultCode().execute();
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public boolean isRunning() {
        return 0 == this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFileLocation()), "check-running").execute();
    }

    public String getPidFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid"});
    }

    @Override
    public void reconfigureService() {
        Map targets = (Map)this.getEntity().getAttribute(HAProxyController.SERVER_POOL_TARGETS);
        LOG.info("Reconfiguring {} with: {}", (Object)this.getEntity(), targets.values());
        for (Entity server : targets.keySet()) {
            Maybe machine = Machines.findUniqueSshMachineLocation((Iterable)server.getLocations());
            if (!machine.isPresentAndNonNull()) continue;
        }
        ImmutableMap substitutions = ImmutableMap.builder().put((Object)"port", this.getEntity().config().get((ConfigKey.HasConfigKey)LoadBalancer.PROXY_HTTP_PORT)).build();
        String template = (String)this.getEntity().config().get(HAProxyController.HAPROXY_CONFIG_TEMPLATE_URL);
        this.copyTemplate(template, this.getConfigFileLocation(), true, (Map)substitutions);
        this.launch();
        LOG.debug("HAProxy re-configured on: {}", (Object)this.getEntity());
    }

    private String getConfigFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "haproxy.cfg"});
    }

    public String getFrontendMode() {
        return (String)this.getEntity().config().get(HAProxyController.FRONTEND_MODE);
    }

    public String getBackendMode() {
        return (String)this.getEntity().config().get(HAProxyController.BACKEND_MODE);
    }

    public String getBindAddress() {
        String host = (String)Optional.fromNullable((Object)this.getEntity().config().get(HAProxyController.BIND_ADDRESS)).or((Object)"*");
        Integer port = (Integer)this.getEntity().getAttribute((AttributeSensor)HAProxyController.PROXY_HTTP_PORT);
        return host + ":" + port;
    }
}

