/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.etcd;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.nosql.etcd.EtcdCluster;
import brooklyn.entity.nosql.etcd.EtcdNode;
import brooklyn.entity.nosql.etcd.EtcdNodeDriver;
import brooklyn.entity.nosql.etcd.EtcdNodeImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.text.Strings;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EtcdNodeSshDriver
extends AbstractSoftwareProcessSshDriver
implements EtcdNodeDriver {
    public EtcdNodeSshDriver(EtcdNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.setAttribute(Attributes.LOG_FILE_LOCATION, this.getLogFileLocation());
    }

    public EtcdNodeImpl getEntity() {
        return (EtcdNodeImpl)EtcdNodeImpl.class.cast(super.getEntity());
    }

    public Set<Integer> getPortsUsed() {
        return ImmutableSet.builder().addAll((Iterable)super.getPortsUsed()).addAll(this.getPortMap().values()).build();
    }

    protected Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"clientPort", (Object)this.getEntity().getAttribute((AttributeSensor)EtcdNode.ETCD_CLIENT_PORT), (Object)"peerPort", (Object)this.getEntity().getAttribute((AttributeSensor)EtcdNode.ETCD_PEER_PORT));
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("etcd-v%s-linux-amd64", this.getVersion()))}));
    }

    public void install() {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        if (!osDetails.isLinux()) {
            throw new IllegalStateException("Machine was not detected as linux: " + this.getMachine() + " Details: " + this.getMachine().getMachineDetails().getOsDetails());
        }
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ArrayList commands = Lists.newArrayList();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add(String.format("tar xvzf %s", saveAs));
        this.newScript((String)"installing").body.append((Collection)commands).failIfBodyEmpty().failOnNonZeroResultCode().execute();
    }

    public void customize() {
        this.newScript("customizing").execute();
        this.entity.setAttribute(EtcdNode.ETCD_NODE_INSTALLED, (Object)Boolean.TRUE);
    }

    public void launch() {
        DynamicTasks.queueIfPossible((TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)this.entity, EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER)).orSubmitAndBlock((Entity)this.entity).andWaitForSuccess();
        boolean clustered = (Boolean)Optional.fromNullable((Object)this.entity.getAttribute(DynamicCluster.CLUSTER_MEMBER)).or((Object)false);
        boolean first = (Boolean)Optional.fromNullable((Object)this.entity.getAttribute(DynamicCluster.FIRST_MEMBER)).or((Object)false);
        String state = first || !clustered ? "new" : "existing";
        String nodes = this.getNodeName() + "=" + this.getPeerUrl();
        if (clustered) {
            Entity cluster = (Entity)this.entity.getAttribute(EtcdCluster.CLUSTER);
            nodes = (String)cluster.getAttribute(EtcdCluster.NODE_LIST);
        }
        LinkedList commands = Lists.newLinkedList();
        commands.add("cd " + this.getRunDir());
        commands.add(String.format("%s -bind-addr 0.0.0.0:%d -advertise-client-urls %s -peer-bind-addr 0.0.0.0:%d -initial-advertise-peer-urls %s -initial-cluster-token %s -name %s -initial-cluster-state %s -initial-cluster %s > %s 2>&1 < /dev/null &", Os.mergePathsUnix((String[])new String[]{this.getExpandedInstallDir(), "etcd"}), this.getEntity().getAttribute((AttributeSensor)EtcdNode.ETCD_CLIENT_PORT), this.getClientUrl(), this.getEntity().getAttribute((AttributeSensor)EtcdNode.ETCD_PEER_PORT), this.getPeerUrl(), this.getClusterToken(), this.getNodeName(), state, nodes, this.getLogFileLocation()));
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").body.append((Collection)commands).failOnNonZeroResultCode().execute();
    }

    public void stop() {
        this.leaveCluster(this.getNodeName());
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    protected String getEtcdCtlCommand() {
        return Os.mergePathsUnix((String[])new String[]{this.getExpandedInstallDir(), "etcdctl"});
    }

    protected String getClientUrl() {
        return String.format("http://%s:%d", this.getHostname(), this.getEntity().getAttribute((AttributeSensor)EtcdNode.ETCD_CLIENT_PORT));
    }

    protected String getPeerUrl() {
        return String.format("http://%s:%d", this.getHostname(), this.getEntity().getAttribute((AttributeSensor)EtcdNode.ETCD_PEER_PORT));
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "console.log"});
    }

    protected String getNodeName() {
        return (String)this.getEntity().getAttribute((AttributeSensor)EtcdNode.ETCD_NODE_NAME);
    }

    protected String getClusterToken() {
        return (String)this.entity.config().get(EtcdCluster.CLUSTER_TOKEN);
    }

    @Override
    public void joinCluster(String nodeName, String nodeAddress) {
        LinkedList commands = Lists.newLinkedList();
        commands.add("cd " + this.getRunDir());
        commands.add(String.format("%s --peers %s member add %s %s", this.getEtcdCtlCommand(), this.getClientUrl(), nodeName, nodeAddress));
        this.newScript((String)"joinCluster").body.append((Collection)commands).failOnNonZeroResultCode().execute();
    }

    @Override
    public void leaveCluster(String nodeName) {
        LinkedList listMembersCommands = Lists.newLinkedList();
        listMembersCommands.add("cd " + this.getRunDir());
        listMembersCommands.add(String.format("%s --peers %s member list", this.getEtcdCtlCommand(), this.getClientUrl()));
        ScriptHelper listMembersScript = this.newScript((String)"listMembers").body.append((Collection)listMembersCommands).gatherOutput();
        int result = listMembersScript.execute();
        if (result != 0) {
            log.warn("{}: The 'member list' command on etcd '{}' failed: {}", new Object[]{this.entity, this.getClientUrl(), result});
            log.debug("{}: STDOUT: {}", (Object)this.entity, (Object)listMembersScript.getResultStdout());
            log.debug("{}: STDERR: {}", (Object)this.entity, (Object)listMembersScript.getResultStderr());
            return;
        }
        String output = listMembersScript.getResultStdout();
        Optional found = Iterables.tryFind((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).split((CharSequence)output), (Predicate)Predicates.containsPattern((String)("name=" + nodeName)));
        if (found.isPresent()) {
            String nodeId = Strings.getFirstWord((String)((String)found.get())).replace(":", "");
            log.debug("{}: Removing etcd node {} with id {} from {}", new Object[]{this.entity, nodeName, nodeId, this.getClientUrl()});
            LinkedList removeMemberCommands = Lists.newLinkedList();
            removeMemberCommands.add("cd " + this.getRunDir());
            removeMemberCommands.add(String.format("%s --peers %s member remove %s", this.getEtcdCtlCommand(), this.getClientUrl(), nodeId));
            this.newScript((String)"removeMember").body.append((Collection)removeMemberCommands).failOnNonZeroResultCode().execute();
        } else {
            log.warn("{}: Did not find {} in list of etcd members", (Object)this.entity, (Object)nodeName);
        }
    }
}

