/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.etcd;

import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.nosql.etcd.EtcdCluster;
import brooklyn.entity.nosql.etcd.EtcdNode;
import brooklyn.entity.nosql.etcd.EtcdNodeDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.util.text.Strings;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNodeImpl
extends SoftwareProcessImpl
implements EtcdNode {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdNode.class);

    public void init() {
        super.init();
        String nodeName = (String)this.config().get((ConfigKey.HasConfigKey)ETCD_NODE_NAME);
        Entity cluster = this.getParent();
        if (cluster instanceof EtcdCluster) {
            this.setAttribute(ETCD_CLUSTER, cluster);
            String clusterName = (String)cluster.config().get(EtcdCluster.CLUSTER_NAME);
            if (Strings.isBlank((CharSequence)nodeName)) {
                nodeName = clusterName;
            }
            AtomicInteger nodeId = (AtomicInteger)cluster.getAttribute(EtcdCluster.NODE_ID);
            nodeName = nodeName + nodeId.incrementAndGet();
        } else {
            this.setAttribute(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER, Boolean.TRUE);
        }
        this.setAttribute((AttributeSensor)ETCD_NODE_NAME, Strings.isBlank((CharSequence)nodeName) ? this.getId() : nodeName);
        LOG.info("Starting {} node: {}", (Object)(cluster instanceof EtcdCluster ? "clustered" : "single"), (Object)this.getNodeName());
    }

    protected String getNodeName() {
        return (String)this.getAttribute((AttributeSensor)EtcdNode.ETCD_NODE_NAME);
    }

    public EtcdNodeDriver getDriver() {
        return (EtcdNodeDriver)super.getDriver();
    }

    public Class<EtcdNodeDriver> getDriverInterface() {
        return EtcdNodeDriver.class;
    }

    public void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
    }

    public void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    @Override
    public void joinCluster(String nodeName, String nodeAddress) {
        this.getDriver().joinCluster(nodeName, nodeAddress);
    }

    @Override
    public void leaveCluster(String nodeName) {
        this.getDriver().leaveCluster(nodeName);
    }

    @Override
    public boolean hasJoinedCluster() {
        return Boolean.TRUE.equals(this.getAttribute(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER));
    }

    static {
        RendererHints.register((AttributeSensor)ETCD_CLUSTER, (RendererHints.Hint)new RendererHints.NamedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
    }
}

