/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.etcd;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.DynamicClusterImpl;
import brooklyn.entity.nosql.etcd.EtcdCluster;
import brooklyn.entity.nosql.etcd.EtcdNode;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.management.TaskAdaptable;
import brooklyn.policy.PolicySpec;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClusterImpl
extends DynamicClusterImpl
implements EtcdCluster {
    private static final Logger log = LoggerFactory.getLogger(EtcdClusterImpl.class);
    private transient Object mutex = new Object[0];

    public void init() {
        super.init();
        this.setAttribute(NODE_ID, new AtomicInteger(0));
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)ETCD_NODE_SPEC);
        this.config().set(MEMBER_SPEC, this.getAttribute((AttributeSensor)ETCD_NODE_SPEC));
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        this.connectSensors();
        super.start(locations);
        Optional anyNode = Iterables.tryFind((Iterable)this.getMembers(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(EtcdNode.class), EntityPredicates.attributeEqualTo(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER, (Object)true), EntityPredicates.attributeEqualTo((AttributeSensor)Startable.SERVICE_UP, (Object)true)}));
        if ((Integer)this.config().get((ConfigKey)Cluster.INITIAL_SIZE) == 0 || anyNode.isPresent()) {
            this.setAttribute(Startable.SERVICE_UP, true);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        } else {
            log.warn("No Etcd nodes are found on the cluster: {}. Initialization Failed", (Object)this.getId());
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
        }
    }

    protected void connectSensors() {
        this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("EtcdCluster node tracker")).configure((CharSequence)"sensorsToTrack", (Object)ImmutableSet.of((Object)Attributes.HOSTNAME)).configure((CharSequence)"group", (Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onServerPoolMemberChanged(Entity member) {
        Object object = this.mutex;
        synchronized (object) {
            log.debug("For {}, considering membership of {} which is in locations {}", new Object[]{this, member, member.getLocations()});
            Map nodes = (Map)this.getAttribute(ETCD_CLUSTER_NODES);
            if (this.belongsInServerPool(member)) {
                if (nodes == null) {
                    nodes = Maps.newLinkedHashMap();
                }
                String name = (String)Preconditions.checkNotNull((Object)this.getNodeName(member));
                DynamicTasks.queueIfPossible((TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)member, EtcdNode.ETCD_NODE_INSTALLED)).orSubmitAndBlock((Entity)this).andWaitForSuccess();
                Entity firstNode = (Entity)this.getAttribute(DynamicCluster.FIRST);
                if (member.equals(firstNode)) {
                    nodes.put(member, name);
                    this.recalculateClusterAddresses(nodes);
                    log.info("Adding first node {}: {}; {} to cluster", new Object[]{this, member, name});
                    ((EntityInternal)member).setAttribute(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER, (Object)Boolean.TRUE);
                } else {
                    int retry = 3;
                    while (retry-- > 0 && member.getAttribute(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER) == null && !nodes.containsKey(member)) {
                        Optional anyNodeInCluster = Iterables.tryFind(nodes.keySet(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(EtcdNode.class), (Predicate)EntityPredicates.attributeEqualTo(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER, (Object)Boolean.TRUE)));
                        if (anyNodeInCluster.isPresent()) {
                            DynamicTasks.queueIfPossible((TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)((Entity)anyNodeInCluster.get()), (AttributeSensor)Startable.SERVICE_UP)).orSubmitAndBlock((Entity)this).andWaitForSuccess();
                            Entities.invokeEffectorWithArgs((EntityLocal)this, (Entity)((Entity)anyNodeInCluster.get()), EtcdNode.JOIN_ETCD_CLUSTER, (Object[])new Object[]{name, this.getNodeAddress(member)}).blockUntilEnded();
                            nodes.put(member, name);
                            this.recalculateClusterAddresses(nodes);
                            log.info("Adding node {}: {}; {} to cluster", new Object[]{this, member, name});
                            ((EntityInternal)member).setAttribute(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER, (Object)Boolean.TRUE);
                            continue;
                        }
                        log.info("Waiting for first node in cluster {}", (Object)this);
                        Time.sleep((Duration)Duration.seconds((Number)15));
                    }
                }
            } else if (nodes != null && nodes.containsKey(member)) {
                Optional anyNodeInCluster = Iterables.tryFind(nodes.keySet(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(EtcdNode.class), EntityPredicates.attributeEqualTo(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER, (Object)Boolean.TRUE), Predicates.not((Predicate)Predicates.equalTo((Object)member))}));
                if (anyNodeInCluster.isPresent()) {
                    Entities.invokeEffectorWithArgs((EntityLocal)this, (Entity)((Entity)anyNodeInCluster.get()), EtcdNode.LEAVE_ETCD_CLUSTER, (Object[])new Object[]{this.getNodeName(member)}).blockUntilEnded();
                }
                nodes.remove(member);
                this.recalculateClusterAddresses(nodes);
                log.info("Removing node {}: {}; {} from cluster", new Object[]{this, member, this.getNodeName(member)});
                ((EntityInternal)member).setAttribute(EtcdNode.ETCD_NODE_HAS_JOINED_CLUSTER, (Object)Boolean.FALSE);
            }
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicatorRequiringNonEmptyMap((EntityLocal)this, (AttributeSensor)ETCD_CLUSTER_NODES);
            log.debug("Done {} checkEntity {}", (Object)this, (Object)member);
        }
    }

    private void recalculateClusterAddresses(Map<Entity, String> nodes) {
        HashMap addresses = Maps.newHashMap();
        for (Entity entity : nodes.keySet()) {
            if (!(entity instanceof EtcdNode)) continue;
            addresses.put(this.getNodeName(entity), this.getNodeAddress(entity));
        }
        this.setAttribute(ETCD_CLUSTER_NODES, nodes);
        this.setAttribute(NODE_LIST, Joiner.on((String)",").withKeyValueSeparator("=").join((Map)addresses));
    }

    protected boolean belongsInServerPool(Entity member) {
        if (member.getAttribute(Attributes.HOSTNAME) == null) {
            log.debug("Members of {}, checking {}, eliminating because hostname not yet set", (Object)this, (Object)member);
            return false;
        }
        if (!this.getMembers().contains(member)) {
            log.debug("Members of {}, checking {}, eliminating because not member", (Object)this, (Object)member);
            return false;
        }
        log.debug("Members of {}, checking {}, approving", (Object)this, (Object)member);
        return true;
    }

    private String getNodeName(Entity node) {
        return (String)node.getAttribute(EtcdNode.ETCD_NODE_NAME);
    }

    private String getNodeAddress(Entity node) {
        return "http://" + (String)node.getAttribute(Attributes.SUBNET_HOSTNAME) + ":" + node.getAttribute((AttributeSensor)EtcdNode.ETCD_PEER_PORT);
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity target) {
            ((EtcdClusterImpl)this.entity).onServerPoolMemberChanged(target);
        }
    }
}

