/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.etcd;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.nosql.etcd.EtcdClusterImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Catalog(name="Etcd Cluster", description="Etcd is an open-source distributed key-value store that serves as the backbone of distributed systems by providing a canonical hub for cluster coordination and state management.")
@ImplementedBy(value=EtcdClusterImpl.class)
public interface EtcdCluster
extends DynamicCluster {
    public static final AttributeSensor<Map<Entity, String>> ETCD_CLUSTER_NODES = Sensors.newSensor((TypeToken)new TypeToken<Map<Entity, String>>(){}, (String)"etcd.cluster.nodes", (String)"Names of all active etcd nodes in the cluster (entity reference to name mapping)");
    @SetFromFlag(value="clusterName")
    public static final ConfigKey<String> CLUSTER_NAME = ConfigKeys.newStringConfigKey((String)"etcd.cluster.name", (String)"The Etcd cluster name", (String)"brooklyn");
    @SetFromFlag(value="clusterToken")
    public static final ConfigKey<String> CLUSTER_TOKEN = ConfigKeys.newStringConfigKey((String)"etcd.cluster.token", (String)"The Etcd cluster token", (String)"brooklyn");
    @SetFromFlag(value="etcdNodeSpec")
    public static final AttributeSensorAndConfigKey<EntitySpec<?>, EntitySpec<?>> ETCD_NODE_SPEC = ConfigKeys.newSensorAndConfigKey((TypeToken)new TypeToken<EntitySpec<?>>(){}, (String)"etcd.node.spec", (String)"Etcd node specification");
    public static final AttributeSensor<AtomicInteger> NODE_ID = Sensors.newSensor(AtomicInteger.class, (String)"etcd.cluster.nodeId", (String)"Counter for generating node IDs");
    public static final AttributeSensor<Boolean> IS_FIRST_NODE_SET = Sensors.newBooleanSensor((String)"etcd.cluster.isFirstNodeSet", (String)"Flag to determine if the first node has been set");
    public static final AttributeSensor<Entity> FIRST_NODE = Sensors.newSensor(Entity.class, (String)"etcd.cluster.firstNode", (String)"The first node in the cluster");
    public static final AttributeSensor<String> NODE_LIST = Sensors.newStringSensor((String)"etcd.cluster.nodeList", (String)"List of nodes (including ports), comma separated");
}

