/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.container.docker.application;

import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.container.docker.DockerContainer;
import brooklyn.entity.container.docker.DockerHost;
import brooklyn.entity.container.docker.application.VanillaDockerApplication;
import brooklyn.entity.container.docker.application.VanillaDockerApplicationDriver;
import brooklyn.entity.container.docker.application.VanillaDockerApplicationImpl;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.docker.DockerContainerLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaDockerApplicationSshDriver
extends AbstractSoftwareProcessSshDriver
implements VanillaDockerApplicationDriver {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaDockerApplicationSshDriver.class);

    public VanillaDockerApplicationSshDriver(VanillaDockerApplicationImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public DockerHost getDockerHost() {
        return this.getDockerContainer().getDockerHost();
    }

    public DockerContainer getDockerContainer() {
        return ((DockerContainerLocation)this.getMachine()).getOwner();
    }

    public String getDockerfile() {
        return (String)this.getEntity().config().get(VanillaDockerApplication.DOCKERFILE_URL);
    }

    public boolean isRunning() {
        return (Boolean)this.getDockerContainer().getAttribute(DockerContainer.CONTAINER_RUNNING);
    }

    public void stop() {
        this.getDockerContainer().shutDown();
    }

    public void install() {
        LOG.info("Container installed on {}", (Object)this.getDockerContainer().getDockerContainerName());
    }

    public void customize() {
    }

    public void launch() {
    }
}

